#pragma once

#include "GamebaseDataTypes.h"
#include "GamebaseInternalModule.h"

#include "Interfaces/IGamebasePurchase.h"
#include "Types/GamebasePurchaseConfiguration.h"
#include "Purchase/GamebasePurchaseDefines.h"

class FGamebasePurchaseInternalStatus;
class FGamebasePurchaseAdapterManager;
struct FGamebaseAuthToken;

DECLARE_DELEGATE_ThreeParams(FGetGamebaseProductsDelegate, const TArray<GamebasePurchase::FIapProductWithMarketItemIdResponse>&, const TArray<GamebasePurchase::FIapProductWithMarketItemIdResponse>&, const FGamebaseError*);
DECLARE_DELEGATE_TwoParams(FGetProductWithGamebaseProductIdDelegate, const GamebasePurchase::FIapProductResponse*, const FGamebaseError*);

class FGamebaseStandalonePurchase final
    : public FGamebaseInternalModule
    , public IGamebasePurchase
{
    using FPurchaseConfiguration = TGamebaseImmutableData<FGamebasePurchaseConfiguration>;
    using FPurchaseAdapterManager = TUniquePtr<FGamebasePurchaseAdapterManager>;
    using FPurchaseInternalStatus = TUniquePtr<FGamebasePurchaseInternalStatus>;
    
public:
    explicit FGamebaseStandalonePurchase(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData);
    virtual ~FGamebaseStandalonePurchase() override;

    void Initialize(const FGamebasePurchaseConfiguration& Configuration);
    
    void SetDebugMode(bool bIsDebugMode);

    virtual void RequestPurchase(int64 ItemSeq, const FGamebasePurchasableReceiptDelegate& Callback) override;
    virtual void RequestPurchase(const FString& GamebaseProductId, const FGamebasePurchasableReceiptDelegate& Callback) override;
    virtual void RequestPurchase(const FString& GamebaseProductId, const FString& Payload, const FGamebasePurchasableReceiptDelegate& Callback) override;

    virtual void RequestItemListOfNotConsumed(const FGamebasePurchasableReceiptListDelegate& Callback) override;
    virtual void RequestItemListOfNotConsumed(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableReceiptListDelegate& Callback) override;

    virtual void RequestItemListPurchasable(const FGamebasePurchasableItemListDelegate& Callback) override;
    virtual void RequestItemListAtIAPConsole(const FGamebasePurchasableItemListDelegate& Callback) override;

    virtual void RequestActivatedPurchases(const FGamebasePurchasableReceiptListDelegate& Callback) override;
    virtual void RequestActivatedPurchases(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableReceiptListDelegate& Callback) override;

    virtual void RequestSubscriptionsStatus(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableSubscriptionStatusDelegate& Callback) override;
    virtual void SetPromotionIAPHandler(const FGamebasePurchasableReceiptDelegate& Callback) override;
    
    void OnUpdateAuthToken(const TOptional<FGamebaseAuthToken>& AuthToken, const TOptional<FString>& ProviderName = TOptional<FString>());
    
    DECLARE_MULTICAST_DELEGATE_OneParam(FFinishPurchase, const FString&);
    FFinishPurchase OnFinishPurchase;

private:
    void RequestGetGamebaseProducts(const FGetGamebaseProductsDelegate& Callback);
    void RequestGetProductWithGamebaseProductId(const FString& GamebaseProductId, const FGetProductWithGamebaseProductIdDelegate& Callback);
    void RequestGetProductsWithMarketItemId(const FString& MarketItemId, const FGetProductsWithMarketItemIdDelegate& Callback);

    void RequestIapUserInfo(const TOptional<FGamebaseAuthToken>& AuthToken);

    void OnPurchaseCompleted(const FString& GamebaseProductId, const TOptional<FGamebasePurchasableReceipt>& ResultData, const FGamebaseError* Error, const FGamebasePurchasableReceiptDelegate& Callback);
    
    FGamebaseErrorPtr CheckApiAvailability() const;
    
private:
    FPurchaseConfiguration CachedConfiguration;
    
    FPurchaseAdapterManager AdapterManager;
    FPurchaseInternalStatus InternalStatus;
};
