﻿#pragma once

#include "GamebaseInternalModule.h"
#include "GamebaseInternalResult.h"
#include "ImageNotice/GamebaseImageNoticeResponse.h"
#include "Interfaces/IGamebaseImageNotice.h"
#include "Types/GamebaseImageNoticeTypes.h"

using FGamebaseImageNoticeViewerPtr = TSharedPtr<class FGamebaseImageNoticeViewer>;
using FGamebaseImageNoticePreferencesPtr = TSharedPtr<class FGamebaseImageNoticePreferences>;

class FGamebaseStandaloneImageNotice final : public FGamebaseInternalModule, public IGamebaseImageNotice
{
    using FResponseWebInfo = GamebaseImageNotice::FResponse::FImageNoticeWeb;
    using FGetImageNoticesResult = FGamebaseInternalResult<FResponseWebInfo>;
    using FGetImageNoticesResultCallback = TFunction<void(const FGetImageNoticesResult&)>;
    
public:
    explicit FGamebaseStandaloneImageNotice(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData)
        : FGamebaseInternalModule(WebSocket, InternalData)
    {
    }
    
    virtual void ShowImageNotices(const FGamebaseImageNoticeConfiguration& Configuration, const FGamebaseErrorDelegate& CloseCallback, const FGamebaseImageNoticeEventDelegate& EventCallback) override;
    virtual void CloseImageNotices() override;

private:
    void RequestGetImageNotices(const FGetImageNoticesResultCallback& Callback);

private:
    bool bWaitRequest = false;
    bool bShowCancel = false;
    
    FGamebaseImageNoticeViewerPtr Viewer;
    FGamebaseImageNoticePreferencesPtr Preferences;
};
