#pragma once

#include "GamebaseInternalModule.h"
#include "Scheduler/GamebaseScheduler.h"

class FGamebaseStandaloneEventHandler;
struct FGamebaseAuthToken;

class FGamebaseStandaloneHeartbeat final : public FGamebaseInternalModule, public FGamebaseScheduler
{
public:
    explicit FGamebaseStandaloneHeartbeat(
        const FGamebaseWebSocketPtr& WebSocket,
        const FGamebaseInternalDataPtr& InternalData,
        const TSharedPtr<FGamebaseStandaloneEventHandler>& EventHandler);
    virtual ~FGamebaseStandaloneHeartbeat() override;
    
    void OnUpdateAuthToken(const TOptional<FGamebaseAuthToken>& AuthToken, const TOptional<FString>& ProviderName = TOptional<FString>());
    
protected:
    virtual void OnUpdateSchedule() override;

private:
    TSharedPtr<FGamebaseStandaloneEventHandler> EventHandler;

    FString IdPCode;
};
