#pragma once

#include "GamebaseInternalModule.h"
#include "IGamebaseGameNotice.h"
#include "GameNotice/GamebaseGameNoticeViewer.h"
#include "Interfaces/IGamebaseGameNotice.h"

using FGamebaseGameNoticeViewerPtr = TSharedPtr<class FGamebaseGameNoticeViewer>;

class FGamebaseStandaloneGameNotice final : public IGamebaseGameNotice, public FGamebaseInternalModule
{
public:
    explicit FGamebaseStandaloneGameNotice(const TSharedPtr<FGamebaseWebSocket>& WebSocket, const TSharedPtr<IGamebaseInternalData>& InternalData)
        : FGamebaseInternalModule(WebSocket, InternalData)
    {
    }
    virtual ~FGamebaseStandaloneGameNotice() override = default;
    
    virtual void OpenGameNotice(const FGamebaseErrorDelegate& Callback) override;

    FGamebaseGameNoticeViewerPtr Viewer;
};
