#include "GamebaseStandaloneGameNotice.h"

#include "GamebaseDebugLogger.h"
#include "GamebaseErrorCode.h"
#include "GamebaseErrorUtil.h"
#include "GamebaseInternalData.h"
#include "GameNotice/GamebaseGameNoticeConstants.h"
#include "GameNotice/GamebaseGameNoticeViewer.h"

void FGamebaseStandaloneGameNotice::OpenGameNotice(const FGamebaseErrorDelegate& CloseCallback)
{
    if (IsInitialize() == false)
    {
        CloseCallback.ExecuteIfBound(GamebaseErrorUtil::NewError(GamebaseGameNotice::Domain, GamebaseErrorCode::NOT_INITIALIZED).Get());
        return;
    }

    const auto LaunchingInfo = InternalData->GetLaunchingInfo();
    if (LaunchingInfo->Launching.App.GameNotice.IsSet() == false)
    {
        CloseCallback.ExecuteIfBound(GamebaseErrorUtil::NewError(GamebaseGameNotice::Domain, GamebaseErrorCode::NOT_INITIALIZED).Get());
        return;
    }

    const auto GameNotice = LaunchingInfo->Launching.App.GameNotice.GetValue();

    if (GameNotice.Url.IsEmpty())
    {
        CloseCallback.ExecuteIfBound(GamebaseErrorUtil::NewError(GamebaseGameNotice::Domain, GamebaseErrorCode::UI_COMMUNITY_FAIL_INVALID_URL, TEXT("Community URL is empty!")).Get());
        return;
    }

    if (Viewer.IsValid())
    {
        GAMEBASE_LOG_WARNING("Already show process game notice.");
        return;
    }

    const auto WebViewCloseCallback = FGamebaseErrorDelegate::CreateLambda([CloseCallback, this](const FGamebaseError* Error)
    {
        CloseCallback.ExecuteIfBound(Error);
        if (Viewer.IsValid())
        {
            Viewer = nullptr;
        }
    });
            
    Viewer = MakeShared<FGamebaseGameNoticeViewer>(InternalData->GetGameInstance(), GameNotice.Url, WebViewCloseCallback);
    Viewer->Show();
    
    //FPlatformProcess::LaunchURL(*GameNotice.Url, nullptr, nullptr);
    CloseCallback.ExecuteIfBound(nullptr);
}
