#pragma once

#include "GamebaseInternalModule.h"
#include "Interfaces/IGamebaseEventHandler.h"
#include "Types/GamebaseEventTypes.h"

class FGamebaseStandaloneEventHandler final : public IGamebaseEventHandler, public FGamebaseInternalModule
{
public:
    FGamebaseStandaloneEventHandler(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData)
        : FGamebaseInternalModule(WebSocket, InternalData)
    {
    }

    virtual FDelegateHandle AddHandler(const FGamebaseEventDelegate::FDelegate& OnCallback) override;
    virtual void RemoveHandler(const FDelegateHandle& Handle) override;
    virtual void RemoveAllHandler() override;

    void Notify(const FGamebaseEventMessage& Message) const;
    
private:
    FGamebaseEventDelegate OnEvent;
};
