#include "GamebaseStandaloneEventHandler.h"

#include "GamebaseDebugLogger.h"

FDelegateHandle FGamebaseStandaloneEventHandler::AddHandler(const FGamebaseEventDelegate::FDelegate& OnCallback)
{
    return OnEvent.Add(OnCallback);
}

void FGamebaseStandaloneEventHandler::RemoveHandler(const FDelegateHandle& Handle)
{
    if (OnEvent.Remove(Handle) == false)
    {
        GAMEBASE_LOG_WARNING("Failed to event handler");
    }
}

void FGamebaseStandaloneEventHandler::RemoveAllHandler()
{
    OnEvent.RemoveAll(this);
}

void FGamebaseStandaloneEventHandler::Notify(const FGamebaseEventMessage& Message) const
{
    GAMEBASE_LOG_DEBUG("message : %s", *Message.Category);
    
    OnEvent.Broadcast(Message);
}
