#include "GamebaseStandaloneCommunity.h"

#include "GamebaseErrorCode.h"
#include "GamebaseErrorUtil.h"
#include "Community/GamebaseCommunityConstants.h"

void FGamebaseStandaloneCommunity::OpenCommunity(const FGamebaseCommunityConfiguration& Configuration, const FGamebaseErrorDelegate& Callback)
{
    if (IsInitialize() == false)
    {
        Callback.ExecuteIfBound(GamebaseErrorUtil::NewError(GamebaseCommunity::Domain, GamebaseErrorCode::NOT_INITIALIZED).Get());
        return;
    }

    if (Configuration.ForcedURL.IsEmpty())
    {
        Callback.ExecuteIfBound(GamebaseErrorUtil::NewError(GamebaseCommunity::Domain, GamebaseErrorCode::UI_COMMUNITY_FAIL_INVALID_URL, TEXT("Community URL is empty!")).Get());
        return;
    }

    FPlatformProcess::LaunchURL(*Configuration.ForcedURL, nullptr, nullptr);
    Callback.ExecuteIfBound(nullptr);
}
