﻿#include "GamebaseGameNoticeViewer.h"
#include "GamebaseGameNoticeConstants.h"

#include "GamebaseDebugLogger.h"
#include "GamebaseErrorCode.h"
#include "GamebaseStandaloneSubsystem.h"
#include "WebView/GamebaseWebViewManager.h"
#include "WebView/GamebaseWebViewOpenParams.h"

class UGamebaseStandaloneSubsystem;

void FGamebaseGameNoticeViewer::Show()
{
    if (OwningGameInstance.IsValid() == false)
    {
        GAMEBASE_LOG_GLOBAL_WARNING("OwningGameInstance is invalid.");
        CloseCallback.ExecuteIfBound(&MakeShared<FGamebaseError, ESPMode::ThreadSafe>(GamebaseErrorCode::UNREAL_GET_ENGINE_INFO_ERROR,
            TEXT("OwningGameInstance is invalid."), GamebaseGameNotice::Domain).Get());
        return;
    }
    
    const auto WebViewCloseCallback = FGamebaseErrorDelegate::CreateLambda([this](const FGamebaseError* Error)
    {
        CloseCallback.ExecuteIfBound(Error);
    });

    constexpr float StandardWebviewWidth = 572.0f;
    constexpr float StandardWebviewHeight = 700.0f;
    constexpr float NavigationBarHeight = 41.0f;
    
    FGamebaseWebViewOpenParams OpenParams;
    OpenParams.Url = Url;

    FVector2D CurrentViewportSize;
    OwningGameInstance->GetGameViewportClient()->GetViewportSize(CurrentViewportSize);

    FVector2D ImageSize = FVector2D(StandardWebviewWidth, StandardWebviewHeight);
    ImageSize.Y += NavigationBarHeight;
    
    OpenParams.ViewportSize = ImageSize;
    
    OpenParams.BackgroundColor = FColor::Black;
    OpenParams.Type = FGamebaseWebViewOpenParams::FloatingPopup;
    
    OpenParams.CloseCallback= [WebViewCloseCallback](const FGamebaseErrorResult& Error)
    {
        WebViewCloseCallback.ExecuteIfBound(nullptr);
    };
    
    if (const UGamebaseStandaloneSubsystem* Subsystem = UGameInstance::GetSubsystem<UGamebaseStandaloneSubsystem>(OwningGameInstance.Get()))
    {
        Subsystem->GetWebViewManager()->Open(OpenParams);
    }
}