#include "GamebaseContactConstants.h"

#include "GamebaseContactTypes.h"
#include "GamebaseInternalData.h"
#include "GamebaseJsonConverter.h"
#include "GamebaseSystemUtils.h"
#include "GamebaseWebViewUtils.h"
#include "GenericPlatform/GenericPlatformHttp.h"

namespace GamebaseContact
{
    FString MakeBaseUrl(const FString& Url);
}

FString GamebaseContact::MakeBaseUrl(const FString& Url)
{
    FString BaseUrl = Url;

    const auto SchemeInfo = GamebaseWebViewUtils::GetSchemeInfo(Url);
    if (SchemeInfo->ParameterMap.Num() > 0)
    {
        BaseUrl += TEXT("&");
    }
    else
    {
        BaseUrl += TEXT("?");
    }

    return BaseUrl;
}

FString GamebaseContact::GetCustomCsUrl(const FString& Url, const TOptional<FGamebaseContactConfiguration>& Configuration)
{
    FString CustomUrl = Url;
        
    if (Configuration.IsSet() && !Configuration->AdditionalURL.IsEmpty())
    {
        CustomUrl = FString::Printf(TEXT("%s%s"), *CustomUrl, *Configuration->AdditionalURL);
    }
        
    if (Configuration.IsSet() && Configuration->ExtraData.Num() > 0)
    {
        const TSharedRef<FJsonObject> ExtraDataJsonObject = MakeShared<FJsonObject>();
        for (const auto& Data : Configuration->ExtraData)
        {
            ExtraDataJsonObject->SetStringField(Data.Key, Data.Value);
        }
    
        CustomUrl = FString::Printf(TEXT("%s?extraData=%s"), *CustomUrl,
                                    *FGenericPlatformHttp::UrlEncode(GamebaseJsonConverter::JsonObjectToJsonString(ExtraDataJsonObject)));
    }

    return CustomUrl;
}

FString GamebaseContact::GetToastCsUrlNotLogin(const FString& Url, const TOptional<FGamebaseContactConfiguration>& Configuration)
{
    FString CustomUrl = Url;
        
    if (Configuration.IsSet() && !Configuration->AdditionalURL.IsEmpty())
    {
        CustomUrl = FString::Printf(TEXT("%s%s"), *CustomUrl, *Configuration->AdditionalURL);
    }

    const FString UserName = (Configuration.IsSet()) ? Configuration->UserName : FString();
        
    CustomUrl = FString::Printf(TEXT("%suserName=%s&osCode=%s"), *MakeBaseUrl(CustomUrl),
                                *FGenericPlatformHttp::UrlEncode(UserName), *FGenericPlatformHttp::UrlEncode(GamebaseSystemUtils::GetPlatform()));
        
    if (Configuration.IsSet() && Configuration->ExtraData.Num() > 0)
    {
        const TSharedRef<FJsonObject> ExtraDataJsonObject = MakeShared<FJsonObject>();
        for (const auto& Data : Configuration->ExtraData)
        {
            ExtraDataJsonObject->SetStringField(Data.Key, Data.Value);
        }
    
        CustomUrl = FString::Printf(TEXT("%s?extraData=%s"), *CustomUrl,
                                    *FGenericPlatformHttp::UrlEncode(GamebaseJsonConverter::JsonObjectToJsonString(ExtraDataJsonObject)));
    }

    return CustomUrl;
}

FString GamebaseContact::GetToastCsUrlLogin(const FToastTypeParameters& Parameters, const TOptional<FGamebaseContactConfiguration>& Configuration)
{
    FString CustomUrl = Parameters.Url;
        
    if (Configuration.IsSet() && !Configuration->AdditionalURL.IsEmpty())
    {
        CustomUrl = FString::Printf(TEXT("%s%s"), *CustomUrl, *Configuration->AdditionalURL);
    }
        
    CustomUrl = FString::Printf(TEXT("%sticket=%s&purpose=%s&userId=%s"), *MakeBaseUrl(CustomUrl),
                                *Parameters.Ticket,
                                *Parameters.Purpose,
                                *Parameters.UserId);

    if (Configuration.IsSet() && !Configuration->UserName.IsEmpty())
    {
        FString UserName = Configuration->UserName;
        
        CustomUrl = FString::Printf(TEXT("%s&userName=%s&osCode=%s"), *CustomUrl,
                                    *FGenericPlatformHttp::UrlEncode(UserName),
                                    *FGenericPlatformHttp::UrlEncode(GamebaseSystemUtils::GetPlatform()));
    }
        
    if (Configuration.IsSet() && Configuration->ExtraData.Num() > 0)
    {
        const TSharedRef<FJsonObject> ExtraDataJsonObject = MakeShared<FJsonObject>();
        for (const auto& Data : Configuration->ExtraData)
        {
            ExtraDataJsonObject->SetStringField(Data.Key, Data.Value);
        }
    
        CustomUrl = FString::Printf(TEXT("%s?extraData=%s"), *CustomUrl, *FGenericPlatformHttp::UrlEncode(GamebaseJsonConverter::JsonObjectToJsonString(ExtraDataJsonObject)));
    }

    return CustomUrl;
}

FString GamebaseContact::GetGamebaseCsUrlNotLogin(const FString& Url, const TOptional<FGamebaseContactConfiguration>& Configuration)
{
    FString CustomUrl = Url;
        
    if (Configuration.IsSet() && !Configuration->AdditionalURL.IsEmpty())
    {
        CustomUrl = FString::Printf(TEXT("%s%s"), *CustomUrl, *Configuration->AdditionalURL);
    }

    if (Configuration.IsSet() && Configuration->ExtraData.Num() > 0)
    {
        const TSharedRef<FJsonObject> ExtraDataJsonObject = MakeShared<FJsonObject>();
        for (const auto& Data : Configuration->ExtraData)
        {
            ExtraDataJsonObject->SetStringField(Data.Key, Data.Value);
        }
    
        CustomUrl = FString::Printf(TEXT("%s?extraData=%s"), *CustomUrl, *FGenericPlatformHttp::UrlEncode(GamebaseJsonConverter::JsonObjectToJsonString(ExtraDataJsonObject)));
    }

    return CustomUrl;
}

FString GamebaseContact::GetGamebaseCsUrl(const FGamebaseTypeParameters& Parameters, const TOptional<FGamebaseContactConfiguration>& Configuration)
{
    FString CustomUrl = Parameters.Url;
        
    if (Configuration.IsSet() && !Configuration->AdditionalURL.IsEmpty())
    {
        CustomUrl = FString::Printf(TEXT("%s%s"), *CustomUrl, *Configuration->AdditionalURL);
    }

    const FString UserName = (Configuration.IsSet()) ? Configuration->UserName : FString();

    CustomUrl = FString::Printf(TEXT("%sticket=%s&purpose=%s&userId=%s&userName=%s&storeCode=%s&clientVersion=%s&sdkVersion=%s&deviceModel=%s&osVersion=%s&deviceCountryCode=%s&usimCountryCode=&osCode=%s"),
                                *MakeBaseUrl(CustomUrl),
                                *Parameters.Ticket,
                                *Parameters.Purpose,
                                *Parameters.UserId,
                                *FGenericPlatformHttp::UrlEncode(UserName),
                                *FGenericPlatformHttp::UrlEncode(*Parameters.StoreCode),
                                *FGenericPlatformHttp::UrlEncode(*Parameters.AppVersion),
                                *FGenericPlatformHttp::UrlEncode(GamebaseSystemUtils::GetPluginVersion()),
                                *FGenericPlatformHttp::UrlEncode(GamebaseSystemUtils::GetDeviceModel()),
                                *FGenericPlatformHttp::UrlEncode(GamebaseSystemUtils::GetPlatform()),
                                *FGenericPlatformHttp::UrlEncode(GamebaseSystemUtils::GetCountryCode()),
                                *FGenericPlatformHttp::UrlEncode(GamebaseSystemUtils::GetPlatform()));
        
    if (Configuration.IsSet() && Configuration->ExtraData.Num() > 0)
    {
        const TSharedRef<FJsonObject> ExtraDataJsonObject = MakeShared<FJsonObject>();
        for (const auto& Data : Configuration->ExtraData)
        {
            ExtraDataJsonObject->SetStringField(Data.Key, Data.Value);
        }
    
        CustomUrl = FString::Printf(TEXT("%s?extraData=%s"), *CustomUrl, *FGenericPlatformHttp::UrlEncode(GamebaseJsonConverter::JsonObjectToJsonString(ExtraDataJsonObject)));
    }

    return CustomUrl;
}
