#pragma once

#include "GamebaseInternalModule.h"
#include "GamebaseInternalResult.h"

using FGamebaseSessionTicketResult = FGamebaseInternalResult<FString>;
using FGamebaseSessionResult = FGamebaseInternalResult<FString>;

class FGamebaseSessionTicketClient final : public FGamebaseInternalModule
{
public:
    using FSessionTicketResultCallback = TFunction<void(const FGamebaseSessionTicketResult&)>;
    using FSessionResultCallback = TFunction<void(const FGamebaseSessionResult&)>;

public:
    FGamebaseSessionTicketClient(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData)
        : FGamebaseInternalModule(WebSocket, InternalData)
    {}
    
    void RequestIssueSessionTicket(int32 ExpiresIn, const FSessionTicketResultCallback& Callback);
    void RequestExchangeSession(const FString& SessionTicketId, const FSessionResultCallback& Callback);
    void RequestDeleteSessionTicket(const FString& SessionTicketId, const FSessionResultCallback& Callback);
};
