#include "GamebaseSessionTicketClient.h"

#include "GamebaseErrorUtil.h"
#include "GamebaseWebSocket.h"
#include "Auth/GamebaseAuthConstants.h"
#include "Auth/GamebaseAuthRequest.h"
#include "Auth/GamebaseAuthResponse.h"
#include "Server/GamebaseServerInfo.h"

void FGamebaseSessionTicketClient::RequestIssueSessionTicket(
    const int32 ExpiresIn,
    const FSessionTicketResultCallback& Callback)
{
    GamebaseAuth::FIssueSessionTicketParameters Parameters;
    Parameters.ExpiresIn = ExpiresIn;
    
    WebSocket->Request(
        GamebaseServerInfo::Gateway::ProductId, 
        GamebaseServerInfo::Gateway::Id::IssueSessionTicket, 
        GamebaseServerInfo::ApiVersion, 
        Parameters,
        [Callback](const FGamebaseWebSocketResponseResult& Response)
        {
            if (Response.IsOk())
            {
                const auto& ResponseSuccessData = Response.GetOkValue();

                if (ResponseSuccessData.Header.bIsSuccessful)
                {
                    GamebaseAuth::FIssueSessionTicketResponse ResponseVo;
                    ResponseVo.FromJson(ResponseSuccessData.OriginData);
                    
                    Callback(FGamebaseSessionTicketResult::Success(ResponseVo.SessionTicketId));
                }
                else
                {
                    const FGamebaseErrorPtr RecvError = GamebaseErrorUtil::NewError(ResponseSuccessData, GamebaseAuth::Domain);
                    Callback(FGamebaseSessionTicketResult::Failure(*RecvError));
                }
            }
            else
            {
                Callback(FGamebaseSessionTicketResult::Failure(Response.GetErrorValue()));
            }
        });
}

void FGamebaseSessionTicketClient::RequestExchangeSession(
    const FString& SessionTicketId,
    const FSessionResultCallback& Callback)
{
    GamebaseAuth::FExchangeSessionTicketParameters Parameters;
    Parameters.SessionTicketId = SessionTicketId;
    
    WebSocket->Request(
        GamebaseServerInfo::Gateway::ProductId, 
        GamebaseServerInfo::Gateway::Id::ExchangeSession, 
        GamebaseServerInfo::ApiVersion, 
        Parameters,
        [Callback](const FGamebaseWebSocketResponseResult& Response)
        {
            if (Response.IsOk())
            {
                const auto& ResponseSuccessData = Response.GetOkValue();

                if (ResponseSuccessData.Header.bIsSuccessful)
                {
                    GamebaseAuth::FExchangeSessionResponse ResponseVo;
                    ResponseVo.FromJson(ResponseSuccessData.OriginData);
                    
                    Callback(FGamebaseSessionResult::Success(ResponseVo.Session));
                }
                else
                {
                    const FGamebaseErrorPtr RecvError = GamebaseErrorUtil::NewError(ResponseSuccessData, GamebaseAuth::Domain);
                    Callback(FGamebaseSessionResult::Failure(*RecvError));
                }
            }
            else
            {
                Callback(FGamebaseSessionResult::Failure(Response.GetErrorValue()));
            }
        });
}

void FGamebaseSessionTicketClient::RequestDeleteSessionTicket(
    const FString& SessionTicketId,
    const FSessionResultCallback& Callback)
{
    GamebaseAuth::FDeleteSessionTicketParameters Parameters;
    Parameters.SessionTicketId = SessionTicketId;
    
    WebSocket->Request(
        GamebaseServerInfo::Gateway::ProductId,
        GamebaseServerInfo::Gateway::Id::DeleteSessionTicket,
        GamebaseServerInfo::ApiVersion,
        Parameters,
        [Callback](const FGamebaseWebSocketResponseResult& Response)
        {
            if (Response.IsOk())
            {
                const auto& ResponseSuccessData = Response.GetOkValue();
                if (ResponseSuccessData.Header.bIsSuccessful)
                {
                    Callback(FGamebaseSessionResult::Success(TEXT("")));
                }
                else
                {
                    const FGamebaseErrorPtr RecvError = GamebaseErrorUtil::NewError(ResponseSuccessData, GamebaseAuth::Domain);
                    Callback(FGamebaseSessionResult::Failure(*RecvError));
                }
            }
            else
            {
                Callback(FGamebaseSessionResult::Failure(Response.GetErrorValue()));
            }
        });
}