#pragma once

#include "CoreMinimal.h"
#include "NhnJsonSerializable.h"
#include "WebSocket/GamebaseWebSocketResponse.h"

namespace GamebaseAuth
{
    struct FMemberResponse final : FNhnJsonSerializable
    {
        struct FAuthMappingInfo final : FNhnJsonSerializable
        {
            FString UserId;
            FString AuthSystem;
            FString IdPCode;
            FString AuthKey;
            int64 RegDate;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("userId", UserId);
                NHN_JSON_SERIALIZE("authSystem", AuthSystem);
                NHN_JSON_SERIALIZE("idPCode", IdPCode);
                NHN_JSON_SERIALIZE("authKey", AuthKey);
                NHN_JSON_SERIALIZE("regDate", RegDate);
            END_NHN_JSON_SERIALIZER
        };
        
        struct FTemporaryWithdrawal final : FNhnJsonSerializable
        {
            int64 GracePeriodDate;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("gracePeriodDate", GracePeriodDate);
            END_NHN_JSON_SERIALIZER
        };

        FString AppId;
        TArray<FAuthMappingInfo> AuthList;
        int64 LastLoginDate;
        int64 RegDate;
        FString UserId;
        FString Valid;
        FTemporaryWithdrawal TemporaryWithdrawal;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("appId", AppId);
            NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("authList", AuthList, FAuthMappingInfo);
            NHN_JSON_SERIALIZE("lastLoginDate", LastLoginDate);
            NHN_JSON_SERIALIZE("regDate", RegDate);
            NHN_JSON_SERIALIZE("userId", UserId);
            NHN_JSON_SERIALIZE("valid", Valid);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("temporaryWithdrawal", TemporaryWithdrawal);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FLoginInfoResponse final : FNhnJsonSerializable
    {
        struct FToken final : FNhnJsonSerializable
        {
            FString AccessToken;
            FString AccessTokenSecret;
            FString SourceIdPCode;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("accessToken", AccessToken);
                NHN_JSON_SERIALIZE("accessTokenSecret", AccessTokenSecret);
                NHN_JSON_SERIALIZE("sourceIdPCode", SourceIdPCode);
            END_NHN_JSON_SERIALIZER
        };
        
        struct FErrorExtras final : FNhnJsonSerializable
        {
            struct FBan final : FNhnJsonSerializable
            {
                FString UserId;
                FString BanType;
                int64 BeginDate;
                int64 EndDate;
                FString Message;
                
                BEGIN_NHN_JSON_SERIALIZER
                    NHN_JSON_SERIALIZE("userId", UserId);
                    NHN_JSON_SERIALIZE("accessTokenSecret", BanType);
                    NHN_JSON_SERIALIZE("beginDate", BeginDate);
                    NHN_JSON_SERIALIZE("endDate", EndDate);
                    NHN_JSON_SERIALIZE("message", Message);
                END_NHN_JSON_SERIALIZER
            };

            FBan Ban;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("ban", Ban);
            END_NHN_JSON_SERIALIZER
        };
        
        FGamebaseHeaderResponse Header;
        FMemberResponse Member;
        FToken Token;
        FErrorExtras ErrorExtras;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("member", Member);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("token", Token);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("errorExtras", ErrorExtras);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FTemporaryWithdrawalInfoResponse final : FNhnJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        FMemberResponse Member;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("member", Member);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FBindIdPTokenResponse final : FNhnJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FIssueSessionTicketResponse final : FNhnJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        FString SessionTicketId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            NHN_JSON_SERIALIZE("sessionTicketId", SessionTicketId);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FExchangeSessionResponse final : FNhnJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        FString Session;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
        NHN_JSON_SERIALIZE("session", Session);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FErrorExtras final : FNhnJsonSerializable
    {
        FString Ban;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_RAW_JSON_STRING("ban", Ban);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FMappingErrorExtras final : FNhnJsonSerializable
    {
        FString ForcingMappingTicket;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_RAW_JSON_STRING("forcingMappingTicket", ForcingMappingTicket);
        END_NHN_JSON_SERIALIZER
    };
}
