#pragma once

#include "CoreMinimal.h"
#include "GamebaseBaseTypes.h"

#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseAuth
{
    struct FLoginParameters final : FGamebaseBaseParameter
    {
        FString AppId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("appId", AppId);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FLoginPayload final : FGamebaseBasePayload
    {
        struct FIdpInfo final : FNhnJsonSerializable
        {
            TOptional<FString> IdPCode;
            TOptional<FString> SubCode;
            TOptional<FString> AccessToken;
            TOptional<FString> AccessTokenSecret;
            TOptional<FString> AuthorizationCode;
            TOptional<FString> Session;
            TOptional<FString> ClientId;
            TOptional<FString> RedirectUri;
            TOptional<FString> AuthorizationProtocol;
            TOptional<FGamebaseVariantMap> ExtraParams;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE_OPTIONAL("idPCode", IdPCode);
                NHN_JSON_SERIALIZE_OPTIONAL("subCode", SubCode);
                NHN_JSON_SERIALIZE_OPTIONAL("accessToken", AccessToken);
                NHN_JSON_SERIALIZE_OPTIONAL("accessTokenSecret", AccessTokenSecret);
                NHN_JSON_SERIALIZE_OPTIONAL("authorizationCode", AuthorizationCode);
                NHN_JSON_SERIALIZE_OPTIONAL("session", Session);
                NHN_JSON_SERIALIZE_OPTIONAL("clientId", ClientId);
                NHN_JSON_SERIALIZE_OPTIONAL("redirectUri", RedirectUri);
                NHN_JSON_SERIALIZE_OPTIONAL("authorizationProtocol", AuthorizationProtocol);
                NHN_JSON_SERIALIZE_OPTIONAL_VARIANT_MAP("extraParams", ExtraParams);
            END_NHN_JSON_SERIALIZER
        };
        
        struct FMember final : FNhnJsonSerializable
        {
            FString ClientVersion;
            FString SDKVersion;
            FString DeviceCountryCode;
            FString DeviceKey;
            FString DeviceModel;
            FString OSCode;
            FString OSVersion;
            FString DeviceLanguage;
            FString DisplayLanguage;
            FString Network;
            FString StoreCode;
            FString Telecom;
            FString UsimCountryCode;
            FString UUID;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE_STRING("clientVersion", ClientVersion);
                NHN_JSON_SERIALIZE_STRING("sdkVersion", SDKVersion);
                NHN_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
                NHN_JSON_SERIALIZE_STRING("deviceKey", DeviceKey);
                NHN_JSON_SERIALIZE_STRING("deviceModel", DeviceModel);
                NHN_JSON_SERIALIZE_STRING("osCode", OSCode);
                NHN_JSON_SERIALIZE_STRING("osVersion", OSVersion);
                NHN_JSON_SERIALIZE_STRING("deviceLanguage", DeviceLanguage);
                NHN_JSON_SERIALIZE_STRING("displayLanguage", DisplayLanguage);
                NHN_JSON_SERIALIZE_STRING("network", Network);
                NHN_JSON_SERIALIZE_STRING("storeCode", StoreCode);
                NHN_JSON_SERIALIZE_STRING("telecom", Telecom);
                NHN_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
                NHN_JSON_SERIALIZE_STRING("uuid", UUID);
            END_NHN_JSON_SERIALIZER
        };

        struct FTokenInfo final : FNhnJsonSerializable
        {
            FString IdPCode;
            FString AccessToken;
            TOptional<FString> SubCode;
            TOptional<FGamebaseVariantMap> ExtraParams;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE_STRING("idPCode", IdPCode);
                NHN_JSON_SERIALIZE_STRING("accessToken", AccessToken);
                NHN_JSON_SERIALIZE_OPTIONAL("subCode", SubCode);
                NHN_JSON_SERIALIZE_OPTIONAL_VARIANT_MAP("extraParams", ExtraParams);
            END_NHN_JSON_SERIALIZER
        };
        
        FIdpInfo IdPInfo;
        FMember Member;
        FTokenInfo TokenInfo;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("idPInfo", IdPInfo);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("member", Member);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("tokenInfo", TokenInfo);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FAddMappingParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        bool bIsForcing;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("userId", UserId);
            NHN_JSON_SERIALIZE("forcing", bIsForcing);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FAddMappingForciblyParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        FString ForcingMappingKey;
        TOptional<FString> MappedUserId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("userId", UserId);
            NHN_JSON_SERIALIZE("forcingMappingKey", ForcingMappingKey);
            NHN_JSON_SERIALIZE_OPTIONAL("mappedUserId", MappedUserId);
        END_NHN_JSON_SERIALIZER
    };

    struct FRemoveMappingParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        FString ProviderName;
        FString AccessToken;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("userId", UserId);
            NHN_JSON_SERIALIZE("idPCode", ProviderName);
            NHN_JSON_SERIALIZE("accessToken", AccessToken);
        END_NHN_JSON_SERIALIZER
    };

    struct FAddMappingForciblyPayload final : FGamebaseBasePayload
    {
        struct FTokenInfo final : FNhnJsonSerializable
        {
            FString AccessToken;
            FString IdPCode;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("accessToken", AccessToken);
                NHN_JSON_SERIALIZE("idPCode", IdPCode);
            END_NHN_JSON_SERIALIZER
        };
        
        FTokenInfo TokenInfo;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("tokenInfo", TokenInfo);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FLogoutParameters final : FGamebaseBaseParameter
    {
        FString AppId;
        FString UserId;
        FString AccessToken;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("appId", AppId);
            NHN_JSON_SERIALIZE_STRING("userId", UserId);
            NHN_JSON_SERIALIZE_STRING("accessToken", AccessToken);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FWithdrawParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("userId", UserId);
        END_NHN_JSON_SERIALIZER
    };

    struct FBindIdPTokenParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("userId", UserId);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FBindIdPTokenPayload final : FGamebaseBasePayload
    {
        struct FIdpInfo final : FNhnJsonSerializable
        {
            FString IdPCode;
            FString Session;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("idPCode", IdPCode);
                NHN_JSON_SERIALIZE("session", Session);
            END_NHN_JSON_SERIALIZER
        };
        
        struct FTokenInfo final : FNhnJsonSerializable
        {
            FString AccessToken;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("accessToken", AccessToken);
            END_NHN_JSON_SERIALIZER
        };
        
        FIdpInfo IdPInfo;
        FTokenInfo TokenInfo;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("idPInfo", IdPInfo);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("tokenInfo", TokenInfo);
        END_NHN_JSON_SERIALIZER
    };

    struct FIssueSessionTicketParameters final : FGamebaseBaseParameter
    {
        int32 ExpiresIn;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("expiresIn", ExpiresIn);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FExchangeSessionTicketParameters final : FGamebaseBaseParameter
    {
        FString SessionTicketId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("sessionTicketId", SessionTicketId);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FDeleteSessionTicketParameters final : FGamebaseBaseParameter
    {
        FString SessionTicketId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("sessionTicketId", SessionTicketId);
        END_NHN_JSON_SERIALIZER
    };
}