#pragma once

#include "CoreMinimal.h"

enum class EGamebaseAuthStep : uint8
{
    None,
    AdapterLogin,
    GamebaseLogin,
    AdapterStoreLogin,
    StoreBindToken,
    AddMapping,
    RemoveMapping,
    AddMappingForcibly,
    ChangeLogin,
};

struct FGamebaseAuthProcessInfo
{
    FString ProviderName;
    FString StoreProviderName;
    FString StoreCode;
    EGamebaseAuthStep Step = EGamebaseAuthStep::None;

    FGamebaseAuthProcessInfo() = default;
    FGamebaseAuthProcessInfo(const FString& ProviderName, const FString& StoreProviderName, const FString& StoreCode)
        : ProviderName(ProviderName), StoreProviderName(StoreProviderName), StoreCode(StoreCode) {}

    void Reset()
    {
        ProviderName.Empty();
        StoreProviderName.Empty();
        StoreCode.Empty();
        Step = EGamebaseAuthStep::None;
    }

    bool IsSet() const
    {
        return !ProviderName.IsEmpty() || Step != EGamebaseAuthStep::None;
    }

    bool IsAdapterLogin() const
    {
        return Step == EGamebaseAuthStep::AdapterLogin || Step == EGamebaseAuthStep::AdapterStoreLogin;
    }

    bool TryNextStep(const EGamebaseAuthStep NextStep)
    {
        switch (NextStep)
        {
            case EGamebaseAuthStep::AdapterLogin:
            case EGamebaseAuthStep::AdapterStoreLogin:
                return true;
                
            case EGamebaseAuthStep::GamebaseLogin:
            case EGamebaseAuthStep::StoreBindToken:
                break;
                
            default:
                return false;
        }
        
        if (Step == EGamebaseAuthStep::None || Step == NextStep)
        {
            Step = NextStep;
            return true;
        }
        
        return false;
    }
};
