#include "GamebaseAuthMemberLoginSystem.h"

FString GamebaseAuth::NeMemberLogin::GetUrl(
    const FGamebaseAuthConfiguration& Configuration,
    const FGamebaseVariantMap& Queries,
    const FString& SvcUrl)
{
    FString LoginUrl = FString::Printf(TEXT("%s?socialNetworkingServiceCode=%s"),
                                       *Configuration.GamebaseLoginUrl,
                                       *Configuration.ProviderName);

    if (Configuration.GbIdClientId.IsSet())
    {
        LoginUrl += FString::Printf(TEXT("&clientId=%s"), *Configuration.GbIdClientId.GetValue());
    }
    
    if (Configuration.SessionTicketId.IsSet() && !Configuration.SessionTicketId.GetValue().IsEmpty())
    {
        LoginUrl += FString::Printf(TEXT("&state=%s"), *Configuration.SessionTicketId.GetValue());
        LoginUrl += TEXT("&callbackType=INTERNAL");
    }
    
    if (SvcUrl.IsEmpty() == false)
    {
        LoginUrl += FString::Printf(TEXT("&svcUrl=%s"), *SvcUrl);
    }
    
    LoginUrl += NHN::Variant::ToQueryToUrl(Queries);
    
    return LoginUrl;
}

FGamebaseAuthMemberResponseData::FGamebaseAuthMemberResponseData(
    const TOptional<FString>& Session,
    const TOptional<FString>& Token,
    const TOptional<FString>& Code): Session(Session), Token(Token), Code(Code)
{
}

FGamebaseAuthMemberResponseData::FGamebaseAuthMemberResponseData(
    const TMap<FString, FString>& Queries)
{
    using namespace GamebaseAuth;

    const auto FindQueryValue = [this, Queries](const FName& Key) -> TOptional<FString>
    {
        const FString KeyString = Key.ToString();
        return Queries.Contains(KeyString) ? Queries[KeyString] : TOptional<FString>();
    };

    Session = FindQueryValue(AuthMemberResponseKey::Session);
    Token = FindQueryValue(AuthMemberResponseKey::Token);
    Code = FindQueryValue(AuthMemberResponseKey::Code);
}

bool FGamebaseAuthMemberResponseData::IsValid() const
{
    return (Session.IsSet() && !Session->IsEmpty()) || (Token.IsSet() && !Token->IsEmpty()) || (Code.IsSet() && !Code->IsEmpty());
}
