#pragma once

#include "GamebaseCoreAuthTypes.h"
#include "GamebaseInternalModule.h"
#include "GamebaseInternalResult.h"
#include "Types/GamebaseAuthTypes.h"

struct FGamebaseWebSocketResponse;
struct FGamebaseAuthToken;
struct FGamebaseError;

class FGamebaseStandaloneContact;
using FGamebaseStandaloneContactPtr = TSharedPtr<FGamebaseStandaloneContact>;

using FGamebaseAuthTokenResult = FGamebaseInternalResult<FGamebaseAuthToken>;
using FGamebaseTemporaryWithdrawalResult = FGamebaseInternalResult<FGamebaseTemporaryWithdrawalInfo>;

class FGamebaseAuthClient final
    : public FGamebaseInternalModule
{
public:
    using FAuthTokenResultCallback = TFunction<void(const FGamebaseAuthTokenResult&)>;
    using FVoidResultCallback = TFunction<void(const FGamebaseErrorResult&)>;
    using FTemporaryWithdrawalResultCallback = TFunction<void(const FGamebaseTemporaryWithdrawalResult&)>;
    
public:
    FGamebaseAuthClient(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData) :
        FGamebaseInternalModule(WebSocket, InternalData)
    {}

    void SetContact(const FGamebaseStandaloneContactPtr& InContact) { Contact = InContact; }
    
    void IdpLogin(const FString& ProviderName, bool bIsAutoLogin, const FGamebaseAuthCredentials& Credentials, const FAuthTokenResultCallback& Callback);
    void TokenLogin(const FString& ProviderName, const FString& AccessToken, const FGamebaseAuthCredentials& Credentials, const FAuthTokenResultCallback& Callback);
    void BindIdPToken(const FString& ProviderName, const FGamebaseAuthCredentials& Credentials, const FVoidResultCallback& Callback);
    void Logout(const FVoidResultCallback& Callback);
    
    void Withdraw(const FVoidResultCallback& Callback);
    void TemporaryWithdrawal(const FTemporaryWithdrawalResultCallback& Callback);
    void CancelTemporaryWithdrawal(const FVoidResultCallback& Callback);

    void AddMapping(const FString& UserId, const FString& ProviderName, const FGamebaseAuthCredentials& Credentials, const FAuthTokenResultCallback& Callback);
    void AddMappingForcibly(const FString& UserId, const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FAuthTokenResultCallback& Callback);
    void RemoveMapping(const FString& ProviderName, const FString& UserId, const FString& AccessToken, const FAuthTokenResultCallback& Callback);
    
private:
    void OnLoginFailedDueToBan(const FGamebaseWebSocketResponse& ResponseSuccessData, const FAuthTokenResultCallback& Callback) const;
    void RequestBanContactUrl(const FString& UserId, const TFunction<void(FString)>& Callback) const;

private:
    FGamebaseStandaloneContactPtr Contact;
};
