#pragma once

#include "GamebaseAdapterCollection.h"
#include "GamebaseCoreAuthTypes.h"
#include "GamebaseInternalDataPointer.h"
#include "GamebaseInternalResult.h"
#include "Types/GamebaseAuthTypes.h"
#include "Types/GamebaseBaseTypes.h"
#include "Types/GamebaseLaunchingTypes.h"

class FGamebaseSessionTicketClient;
class UGamebaseStandaloneAuthAdapter;
class IGamebaseAuthAdapter;
class FGamebaseAuthClient;

using FGamebaseAuthAdapterPtr = TUniquePtr<IGamebaseAuthAdapter>;
using FGamebaseLaunchingIdPInfo = FGamebaseLaunchingInfo::FLaunching::FApp::FIdp;
using FGamebaseLaunchingIdPMap = TMap<FString, FGamebaseLaunchingIdPInfo>;

class FGamebaseAuthAdapterManager
{
    using FAuthAdapterCollection = TGamebaseAdapterCollection<UGamebaseStandaloneAuthAdapter>;
    
public:
    explicit FGamebaseAuthAdapterManager(const FGamebaseInternalDataPtr& InternalData);
    ~FGamebaseAuthAdapterManager();
    
    void Initialize(const FGamebaseLaunchingIdPMap& IdPMap);
    
    void SetSessionTicketClient(const TWeakPtr<FGamebaseSessionTicketClient>& InSessionTicketClient);

    using FLoginCallback = TFunction<void(const FGamebaseAuthCredentialsResult&)>;
    void Login(const FString& ProviderName, const FLoginCallback& Callback);
    void Login(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FLoginCallback& Callback);
    
    using FCancelLoginCallback = TFunction<void(const FGamebaseErrorResult&)>;
    void CancelLogin(const FString& ProviderName, const FCancelLoginCallback& Callback);
    
    using FLogoutCallback = TFunction<void(const FGamebaseErrorResult&)>;
    void Logout(const FString& ProviderName, const FLogoutCallback& Callback);
    void LogoutAll(const FLogoutCallback& Callback);

    using FWithdrawCallback = TFunction<void(const FGamebaseErrorResult&)>;
    void Withdraw(const FString& ProviderName, const FWithdrawCallback& Callback);
    void WithdrawAll(const FWithdrawCallback& Callback);

    FString GetUserID(const FString& ProviderName);
    FString GetAccessToken(const FString& ProviderName);
    FGamebaseAuthProviderProfilePtr GetProfile(const FString& ProviderName);
    
    bool HasAdapter(const FString& ProviderName) const;
    
    void OnUpdateLaunchingInfo(const FGamebaseLaunchingInfo& LaunchingInfo);

private:
    void UpdateLaunchingIdpInfo(const FGamebaseLaunchingIdPMap& IdPInfo);

private:
    FGamebaseInternalDataPtr InternalData;
    
    bool bIsInitialize = false;
    FString GamebaseLoginUrl;

    FAuthAdapterCollection LoadedAdapters;
    TWeakPtr<FGamebaseSessionTicketClient> SessionTicketClient;
};
