﻿#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseAnalytics
{
    struct FParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("userId", UserId);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FUserMetaData final : FNhnJsonSerializable
    {
        int32 UserLevel;
        int64 LevelUpTime;
        FString ChannelId;
        FString CharacterId;
        FString CharacterClassId;
            
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("userLevel", UserLevel);
            NHN_JSON_SERIALIZE("levelUpTime", LevelUpTime);
            NHN_JSON_SERIALIZE_STRING("channelId", ChannelId);
            NHN_JSON_SERIALIZE_STRING("characterId", CharacterId);
            NHN_JSON_SERIALIZE_STRING("characterClassId", CharacterClassId);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FUserMetaPayload final : FGamebaseBasePayload
    {
        FString AppId;
        FString IdPCode;
        FString ThirdIdPCode;
        FUserMetaData UserMetaData;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("appId", AppId);
            NHN_JSON_SERIALIZE_STRING("idPCode", IdPCode);
            NHN_JSON_SERIALIZE_STRING("thirdIdPCode", ThirdIdPCode);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("userMetaData", UserMetaData);
        END_NHN_JSON_SERIALIZER
    };

    struct FPurchasePayload final : FGamebaseBasePayload
    {
        FString AppId;
        FString PaySeq;
        FString ClientVersion;
        FString IdPCode;
        FString DeviceModel;
        FString OSCode;
        FString UsimCountryCode;
        FString DeviceCountryCode;
        FString SubStoreCode;
        FUserMetaData UserMetaData;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("appId", AppId);
            NHN_JSON_SERIALIZE_STRING("paySeq", PaySeq);
            NHN_JSON_SERIALIZE_STRING("clientVersion", ClientVersion);
            NHN_JSON_SERIALIZE_STRING("idPCode", IdPCode);
            NHN_JSON_SERIALIZE_STRING("deviceModel", DeviceModel);
            NHN_JSON_SERIALIZE_STRING("osCode", OSCode);
            NHN_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
            NHN_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
            NHN_JSON_SERIALIZE_STRING("subStoreCode", SubStoreCode);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("userMetaData", UserMetaData);
        END_NHN_JSON_SERIALIZER
    };
}
