﻿#include "WebSocketsModule.h"
#include "Modules/ModuleManager.h"
#include "Utils/GamebaseUtils.h"

class FGamebaseStandaloneModule final : public IModuleInterface
{
public:
    virtual void StartupModule() override;
    virtual void ShutdownModule() override;
};

#define LOCTEXT_NAMESPACE "FGamebaseStandaloneModule"

void FGamebaseStandaloneModule::StartupModule()
{
    FModuleManager::LoadModuleChecked<FWebSocketsModule>("WebSockets");
    
    GamebaseUtils::ImportDll();
}

void FGamebaseStandaloneModule::ShutdownModule()
{
    GamebaseUtils::ShutdownDll();
}

#undef LOCTEXT_NAMESPACE
    
IMPLEMENT_MODULE(FGamebaseStandaloneModule, GamebaseStandalone)