#include "Modules/ModuleInterface.h"

#include "GamebaseAndroidPlatformSettings.h"
#include "GamebaseIOSPlatformSettings.h"
#include "GamebaseWindowsPlatformSettings.h"

#if WITH_EDITOR
#include "ISettingsModule.h"
#endif

class FGamebaseEditor final : public IModuleInterface
{
public:
    virtual void StartupModule() override;
    virtual void ShutdownModule() override;
};

#define LOCTEXT_NAMESPACE "FGamebaseEditor"

void FGamebaseEditor::StartupModule()
{
#if WITH_EDITOR
    ISettingsModule* SettingsModule = FModuleManager::GetModulePtr<ISettingsModule>("Settings");

    if (SettingsModule != nullptr)
    {
        SettingsModule->RegisterSettings("Project", "Plugins", "Gamebase - Android",
            LOCTEXT("GamebaseAndroidSettingsName", "Gamebase - Android"),
            LOCTEXT("GamebaseAndroidSettingsDescription", "Settings for Gamebase Android"),
            GetMutableDefault<UGamebaseAndroidPlatformSettings>());

        SettingsModule->RegisterSettings("Project", "Plugins", "Gamebase - iOS",
            LOCTEXT("GamebaseiOSSettingsName", "Gamebase - iOS"),
            LOCTEXT("GamebaseiOSSettingsDescription", "Settings for Gamebase iOS"),
            GetMutableDefault<UGamebaseIOSPlatformSettings>());

        SettingsModule->RegisterSettings("Project", "Plugins", "Gamebase - Windows",
            LOCTEXT("GamebaseWindowsSettingsName", "Gamebase - Windows"),
            LOCTEXT("GamebaseWindowsSettingsDescription", "Settings for Gamebase Windows"),
            GetMutableDefault<UGamebaseWindowsPlatformSettings>());
    }
#endif
}

void FGamebaseEditor::ShutdownModule()
{
#if WITH_EDITOR
    ISettingsModule* SettingsModule = FModuleManager::GetModulePtr<ISettingsModule>("Settings");

    if (SettingsModule != nullptr)
    {
        SettingsModule->UnregisterSettings("Project", "Plugins", "Gamebase - Android");
        SettingsModule->UnregisterSettings("Project", "Plugins", "Gamebase - iOS");
        SettingsModule->UnregisterSettings("Project", "Plugins", "Gamebase - Windows");
    }
#endif
}

#undef LOCTEXT_NAMESPACE

IMPLEMENT_MODULE(FGamebaseEditor, GamebaseEditor);