#pragma once

namespace GamebasePopup
{
    struct FGamebasePopupButton final
    {
        using FClickFunction = TFunction<void()>;
    
        const FString Name;
        const FClickFunction Callback;

        FGamebasePopupButton(const FString& Name, const FClickFunction& Callback) : Name(Name), Callback(Callback)
        {
        }
    };
    using FGamebasePopupButtonPtr = TSharedPtr<FGamebasePopupButton>;

    GAMEBASECORE_API void ShowPopup(const FString& Title, const FString& Message, const FGamebasePopupButtonPtr Button1 = nullptr, const FGamebasePopupButtonPtr Button2 = nullptr);
}