#pragma once

#include "GamebaseAuthProviderCredential.h"
#include "GamebaseLaunchingTypes.h"
#include "GamebaseJsonConverter.h"

using FGamebaseStability = FGamebaseLaunchingInfo::FLaunching::FTcgbClient::FStability;

namespace GamebaseJsonSecurity
{
    static TArray<FString> SecurityBlacklist = {
        TEXT("accessToken"),
        TEXT("X-TCGB-Access-Token"),
        TEXT("authorizationCode"),
        TEXT("clientId"),
        TEXT("iosClientId"),
        TEXT("clientSecret"),
        TEXT("uuid"),
        TEXT("facebook_client_token"),
        TEXT("authKey"),
        TEXT("appKeyIndicator"),
        TEXT("appKeyLog"),
        TEXT("appKey")
    };

    static void SetBlackList(const FGamebaseStability& Stability)
    {
        if(Stability.SecurityBlacklist.Num() > 0)
        {
            SecurityBlacklist.Append(Stability.SecurityBlacklist);
        }
        else
        {
            TArray<FString> DefaultBlacklist = {
                GamebaseAuthProviderCredential::AccessToken.ToString(),
                GamebaseAuthProviderCredential::GamebaseAccessToken.ToString(),
                GamebaseAuthProviderCredential::AccessTokenSecret.ToString(),
                GamebaseAuthProviderCredential::AuthorizationCode.ToString(),
                GamebaseAuthProviderCredential::CodeVerifier.ToString()
            };

            SecurityBlacklist.Append(DefaultBlacklist);
        }            
    }

    static FString MaskingJson(const FString& JsonString);
    
    static const TSharedPtr<FJsonObject>& Masking(const TSharedPtr<FJsonObject>& JsonObject){
        TMap<FString, TSharedPtr<FJsonValue>> JsonValues = JsonObject->Values;
        for ( const  auto & Element : JsonValues)
        {
            const TSharedPtr<FJsonValue>& JsonValue = Element.Value;

            if(JsonValue.IsValid())
            {
                if (JsonValue->Type == EJson::Object)
                {
                    Masking(JsonValue->AsObject());
                }
                else if(JsonValue->Type == EJson::Array)
                {
                    TArray< TSharedPtr<FJsonValue> > ArrayValue = JsonValue->AsArray();
                    for( auto ArrayIter = ArrayValue.CreateConstIterator(); ArrayIter; ++ArrayIter )
                    {
                        const TSharedPtr< FJsonValue >& Item = *ArrayIter;
                        if( Item.IsValid() && Item->Type == EJson::Object )
                        {
                            Masking(Item->AsObject());
                        }
                    }
                }
                else if (JsonValue->Type == EJson::String)
                {
                    bool ISSecurityKey = false;
                    for (const auto& SecurityKey : SecurityBlacklist)
                    {
                        if(SecurityKey.Equals(Element.Key))
                        {
                            ISSecurityKey = true;
                            break;
                        }
                    }

                    if(ISSecurityKey)
                    {
                        JsonObject->SetStringField(Element.Key, TEXT("..."));
                    }
                    else
                    {
                        JsonObject->SetStringField(Element.Key, MaskingJson(Element.Value->AsString()));
                    }
                }
            }
        }

        return JsonObject;
    }

    static FString MaskingJson(const FString& JsonString)
    {
        TSharedPtr<FJsonObject> Object;
        const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(JsonString);
        if (FJsonSerializer::Deserialize(Reader, Object) && Object.IsValid())
        {
            return GamebaseJsonConverter::JsonObjectToJsonString(Masking(Object).ToSharedRef());
        }
    
        return JsonString;
    }
}