﻿#pragma once

#include "NhnJsonSerializeMacros.h"

struct FGamebaseConfiguration;
struct FGamebaseLaunchingInfo;

struct GAMEBASECORE_API FGamebasePurchaseConfiguration final : FNhnJsonSerializable
{
    FString ZoneType;
    FString IapAppkey;
    FString StoreCode;
    FString StoreId;
    FString StoreAppId;
    bool bIsLaunchingSandbox;
    FString ServerUrl;
    
    bool IsValid() const
    {
        return !IapAppkey.IsEmpty() && !StoreCode.IsEmpty() && !StoreId.IsEmpty() && !StoreAppId.IsEmpty();
    }
        
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("zoneType", ZoneType);
        NHN_JSON_SERIALIZE("iapAppkey", IapAppkey);
        NHN_JSON_SERIALIZE("storeCode", StoreCode);
        NHN_JSON_SERIALIZE("storeId", StoreId);
        NHN_JSON_SERIALIZE("storeAppId", StoreAppId);
        NHN_JSON_SERIALIZE("isLaunchingSandbox", bIsLaunchingSandbox);
        NHN_JSON_SERIALIZE("serverUrl", ServerUrl);
    END_NHN_JSON_SERIALIZER
};