#pragma once

#include "CoreMinimal.h"

class IGamebaseSystemInfo
{
public:
    virtual ~IGamebaseSystemInfo() = default;

    virtual void RequestLastLoggedInProvider(const FGamebaseLastLoggedInProviderDelegate& Callback) const = 0;
    virtual FString GetLastLoggedInProvider() const = 0;
    
    virtual FString GetUserID() const = 0;
    virtual FString GetAccessToken() const = 0;

    virtual FString GetSDKVersion() const = 0;
    virtual bool IsSandbox() const = 0;

    virtual FString GetDisplayLanguageCode() const = 0;
    virtual void SetDisplayLanguageCode(const FString& LanguageCode) = 0;

    virtual FString GetDeviceLanguageCode() const = 0;
    virtual FString GetCarrierCode() const = 0;
    virtual FString GetCarrierName() const = 0;
    virtual FString GetCountryCode() const = 0;
    virtual FString GetCountryCodeOfUSIM() const = 0;
    virtual FString GetCountryCodeOfDevice() const = 0;
};