#pragma once

#include "CoreMinimal.h"
#include "Types/GamebaseAuthTypes.h"

class IGamebaseAuth
{ 
public:
    virtual ~IGamebaseAuth() = default;

    virtual void Login(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void Login(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void Login(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void LoginForLastLoggedInProvider(const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void LoginForLastLoggedInProvider(const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) = 0;

    virtual void AddMapping(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void AddMapping(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void AddMapping(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) = 0;

    virtual void ChangeLogin(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void AddMappingForcibly(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) = 0;
    
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void AddMappingForcibly(const FGamebaseVariantMap& CredentialInfo, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) = 0;
    virtual void RemoveMapping(const FString& ProviderName, const FGamebaseErrorDelegate& Callback) = 0;
    
    virtual void Logout(const FGamebaseErrorDelegate& Callback) = 0;
    virtual void Withdraw(const FGamebaseErrorDelegate& Callback) = 0;
    virtual void WithdrawImmediately(const FGamebaseErrorDelegate& Callback) = 0;
    virtual void RequestTemporaryWithdrawal(const FGamebaseTemporaryWithdrawalDelegate& Callback) = 0;
    virtual void CancelTemporaryWithdrawal(const FGamebaseErrorDelegate& Callback) = 0;

    virtual void IssueTransferAccount(const FGamebaseTransferAccountDelegate& Callback) = 0;
    virtual void QueryTransferAccount(const FGamebaseTransferAccountDelegate& Callback) = 0;
    virtual void RenewTransferAccount(const FGamebaseTransferAccountRenewConfiguration& Configuration, const FGamebaseTransferAccountDelegate& Callback) = 0;
    virtual void TransferAccountWithIdPLogin(const FString& AccountId, const FString& AccountPassword, const FGamebaseAuthTokenDelegate& Callback) = 0;

    virtual TArray<FString> GetAuthMappingList() = 0;
    virtual FString GetAuthProviderUserID(const FString& ProviderName) = 0;
    virtual FString GetAuthProviderAccessToken(const FString& ProviderName) = 0;
    virtual const FGamebaseAuthProviderProfilePtr GetAuthProviderProfile(const FString& ProviderName) = 0;

    virtual const FGamebaseBanInfoPtr GetBanInfo() = 0;
};