#pragma once

class IGamebaseDisplayLanguage
{
public:
    using FLanguageCode = FString;
    using FLocalizedStringKey = FString;
    using FLocalizedStringValue = FString;

    virtual ~IGamebaseDisplayLanguage() = default;
    
    virtual void SetLanguageCode(const FLanguageCode& LanguageCode) = 0;
    virtual void UpdateLaunchingLanguageCode(const FLanguageCode& DeviceLanguage, const FLanguageCode& DefaultLanguage) = 0;
    
    virtual FLanguageCode GetDisplayLanguageCode() const = 0;
    virtual FLocalizedStringValue GetLocalizedString(const FLocalizedStringKey& Key) const = 0;
};