#pragma once

#include "GamebaseCoreSubsystem.h"

template <typename TSubsystem>
class TGamebaseSubsystemAware
{
    static_assert(
        TIsDerivedFrom<TSubsystem, UGamebaseCoreSubsystem>::IsDerived,
        "TSubsystem must derive from UGamebaseCoreSubsystem");

public:
    TGamebaseSubsystemAware() = delete;

    explicit TGamebaseSubsystemAware(const TWeakObjectPtr<TSubsystem>& Subsystem)
        : WeakSubsystem(Subsystem)
    {
    }

    virtual ~TGamebaseSubsystemAware() = default;

    TSubsystem* GetSubsystem() const
    {
        return WeakSubsystem.Get();
    }

    bool IsValidSubsystem() const
    {
        return WeakSubsystem.IsValid();
    }
    
private:
    TWeakObjectPtr<TSubsystem> WeakSubsystem;
};
