#pragma once

#include "GamebaseBaseTypes.h"

struct FGamebasePurchaseConfiguration;
class IGamebaseInternalData;
struct FGamebaseWebViewConfiguration;
struct FGamebaseConfiguration;
struct FGamebaseTransferAccountRenewConfiguration;
struct FGamebaseAnalyticsLevelUpData;
struct FGamebaseAnalyticsUserData;
struct FGamebasePurchasableReceipt;
struct FGamebaseForcingMappingTicket;
struct FGamebaseError;

namespace GamebaseInternalReport
{
    namespace Network
    {
        GAMEBASECORE_API void ChangeDomainSuccess(const IGamebaseInternalData& InternalData, const FString& Domain);
        GAMEBASECORE_API void DomainConnectionFailed(const IGamebaseInternalData& InternalData, const FGamebaseError* Error);
    }

    namespace Init
    {
        GAMEBASECORE_API void EngineInformation(const IGamebaseInternalData& InternalData);
        GAMEBASECORE_API void FailedMultipleTime(const IGamebaseInternalData& InternalData, const FGamebaseConfiguration& Configuration, const FGamebaseError* Error);
    }
    
    namespace Auth
    {
        GAMEBASECORE_API void LastProviderLogin(const IGamebaseInternalData& InternalData, const FString& Provider, const FGamebaseError* Error);
        GAMEBASECORE_API void LoginWithProvider(const IGamebaseInternalData& InternalData, const FString& Provider, const FGamebaseError* Error);
        GAMEBASECORE_API void LoginWithCredential(const IGamebaseInternalData& InternalData, const FGamebaseVariantMap& CredentialInfo, const FGamebaseError* Error);
        GAMEBASECORE_API void MappingWithProvider(const IGamebaseInternalData& InternalData, const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseError* Error);
        GAMEBASECORE_API void ChangeLogin(const IGamebaseInternalData& InternalData, const FGamebaseVariantMap& Credential, const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseError* Error);
        GAMEBASECORE_API void Logout(const IGamebaseInternalData& InternalData, const FGamebaseError* Error, const FGamebaseVariantMap& AdditionalInfo);
        GAMEBASECORE_API void Withdraw(const IGamebaseInternalData& InternalData, const FGamebaseError* Error);
        GAMEBASECORE_API void RenewTransfer(const IGamebaseInternalData& InternalData, const FGamebaseTransferAccountRenewConfiguration& Configuration);
        GAMEBASECORE_API void RequestTemporaryWithdrawal(const IGamebaseInternalData& InternalData, const FGamebaseError* Error);
        GAMEBASECORE_API void CancelTemporaryWithdrawal(const IGamebaseInternalData& InternalData, const FGamebaseError* Error);
    }

    namespace Event
    {
        GAMEBASECORE_API void ObserverBannedMember(const IGamebaseInternalData& InternalData, const FString& ObserverData);
        GAMEBASECORE_API void ObserverInvalidMember(const IGamebaseInternalData& InternalData, const FString& ObserverData);
        GAMEBASECORE_API void ServerPushAppKickOut(const IGamebaseInternalData& InternalData, const FString& ServerPushData);
        GAMEBASECORE_API void ServerPushTransferKickOut(const IGamebaseInternalData& InternalData, const FString& ServerPushData);
        GAMEBASECORE_API void ServerPushTransferKickOut(const IGamebaseInternalData& InternalData, const FString& ServerPushData);
        GAMEBASECORE_API void LoggedOut(const IGamebaseInternalData& InternalData, const FString& LoggedOutData);
    }

    namespace TAA
    {
        GAMEBASECORE_API void SetGameUserData(const IGamebaseInternalData& InternalData, int32 UserLevel, const FGamebaseAnalyticsUserData& UserData, const FGamebaseError* Error);
        GAMEBASECORE_API void TraceLevelUp(const IGamebaseInternalData& InternalData, int32 UserLevel, const FGamebaseAnalyticsLevelUpData& LevelUpData, const FGamebaseError* Error);
        GAMEBASECORE_API void ResetUserLevel(const IGamebaseInternalData& InternalData, const FString& Message = {});
        GAMEBASECORE_API void SendPurchaseCompleteAnalytics(const IGamebaseInternalData& InternalData, int32 UserLevel, const FString& StoreCode, const FString& PaymentSeq, const FGamebaseError* Error);
    }
    
    namespace Purchase
    {
        GAMEBASECORE_API void InitFailed(const IGamebaseInternalData& InternalData, const FGamebasePurchaseConfiguration& Configuration, const FString& ErrorMessage);
        GAMEBASECORE_API void Purchase(const IGamebaseInternalData& InternalData, const FGamebasePurchaseConfiguration& Configuration, const FString& GamebaseProductId, const FGamebasePurchasableReceipt* Receipt, const FGamebaseError* Error);
        GAMEBASECORE_API void ItemListFailed(const IGamebaseInternalData& InternalData, const FString& IapAppkey, const FGamebaseError* Error);
        GAMEBASECORE_API void WrongChangedStoreCode(const IGamebaseInternalData& InternalData, const FString& CurrentStoreCode, const FString& NewStoreCode);
        GAMEBASECORE_API void PurchaseInvalidReceipt(const IGamebaseInternalData& InternalData, const FGamebasePurchasableReceipt& Receipts);
        GAMEBASECORE_API void ConsumableListNotEmpty(const IGamebaseInternalData& InternalData, const FString& IapAppkey, const FString& ReceiptListJsonString);
        GAMEBASECORE_API void ConsumableListFailed(const IGamebaseInternalData& InternalData, const FString& IapAppkey, const FGamebaseError* Error);
    }
    
    namespace Push
    {
    }
    
    namespace WebView
    {
        GAMEBASECORE_API void Open(const IGamebaseInternalData& InternalData, const FString& Url, const FGamebaseWebViewConfiguration* Configuration, const FGamebaseError* Error);
    }
    
    namespace Terms
    {
        GAMEBASECORE_API void UpdateFailedAgain(const IGamebaseInternalData& InternalData, int32 TermsSeq, const FString& TermsVersion, const FString& Payload, const FGamebaseError* Error);
    }
    
    namespace Common
    {
        GAMEBASECORE_API void WrongUsage(const IGamebaseInternalData& InternalData, const FString& FunctionName, const FString& ErrorLog, const FGamebaseError* Error = nullptr, const FString& Payload = {});
        GAMEBASECORE_API void DebugMessage(const IGamebaseInternalData& InternalData, const FString& Message);
        GAMEBASECORE_API void WarnMessage(const IGamebaseInternalData& InternalData, const FString& Message);
        GAMEBASECORE_API void ErrorMessage(const IGamebaseInternalData& InternalData, const FString& Message);
        GAMEBASECORE_API void CheckAPI(const IGamebaseInternalData& InternalData, const FString& ApiName);
    }
}