#pragma once

#include "CoreMinimal.h"

class IGamebaseInternalData;

GAMEBASECORE_API DECLARE_LOG_CATEGORY_EXTERN(LogGamebase, Log, All);

#define LOG_MESSAGE(Format, ...) \
    *FString::Printf(TEXT("[TCGB] %s : %s"), ANSI_TO_TCHAR(__FUNCTION__), *FString::Printf(TEXT(Format), ##__VA_ARGS__))

#define GAMEBASE_LOG_DEBUG_N(Format, ...) \
    if (FGamebaseDebugLogger::IsDebugLog) \
        FGamebaseDebugLogger::Debug(LOG_MESSAGE(Format, ##__VA_ARGS__), *InternalData);
    
#define GAMEBASE_LOG_WARNING_N(Format, ...) \
    FGamebaseDebugLogger::Warning(LOG_MESSAGE(Format, ##__VA_ARGS__), *InternalData);

#define GAMEBASE_LOG_ERROR_N(Format, ...) \
    FGamebaseDebugLogger::Error(LOG_MESSAGE(Format, ##__VA_ARGS__), *InternalData);


#define GAMEBASE_LOG_DEBUG(Format, ...) \
    if (FGamebaseDebugLogger::IsDebugLog) \
        FGamebaseDebugLogger::Debug(LOG_MESSAGE(Format, ##__VA_ARGS__), *InternalData);
    
#define GAMEBASE_LOG_WARNING(Format, ...) \
    FGamebaseDebugLogger::Warning(LOG_MESSAGE(Format, ##__VA_ARGS__), *InternalData);

#define GAMEBASE_LOG_ERROR(Format, ...) \
    FGamebaseDebugLogger::Error(LOG_MESSAGE(Format, ##__VA_ARGS__), *InternalData);


#define GAMEBASE_LOG_GLOBAL_DEBUG(Format, ...) \
    if (FGamebaseDebugLogger::IsDebugLog) \
        FGamebaseDebugLogger::Debug(LOG_MESSAGE(Format, ##__VA_ARGS__));

#define GAMEBASE_LOG_GLOBAL_WARNING(Format, ...) \
    FGamebaseDebugLogger::Warning(LOG_MESSAGE(Format, ##__VA_ARGS__));

#define GAMEBASE_LOG_GLOBAL_ERROR(Format, ...) \
    FGamebaseDebugLogger::Error(LOG_MESSAGE(Format, ##__VA_ARGS__));

#define GAMEBASE_NOT_SUPPORT_API() \
    GAMEBASE_LOG_GLOBAL_DEBUG("Not supported platform");


class GAMEBASECORE_API FGamebaseDebugLogger
{
public:
    static bool IsDebugLog;
    
    static void Debug(const FString& Message);
    static void Warning(const FString& Message);
    static void Error(const FString& Message);

    static void Debug(const FString& Message, const IGamebaseInternalData& InternalData);
    static void Warning(const FString& Message, const IGamebaseInternalData& InternalData);
    static void Error(const FString& Message, const IGamebaseInternalData& InternalData);

private:
    FGamebaseDebugLogger() = delete;
};