﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerCrashData.h"
#include "GpLoggerTypes.h"
#include "UObject/Object.h"
#include "Interfaces/IGamebaseLogger.h"
#include "GamebaseCoreLogger.generated.h"

UCLASS()
class GAMEBASECORE_API UGamebaseCoreLogger : public UObject, public IGamebaseLogger
{
    GENERATED_BODY()
    
public:
    virtual void Initialize(const FGamebaseLoggerConfiguration& LoggerConfiguration) override;
    virtual void Debug(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void Info(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void Warn(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void Error(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void Fatal(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void SetUserField(const FString& Key, const FString& Value) override;
    virtual void SetListener(const FGamebaseLoggerListener& Listener) override;
    virtual void SetCrashFilter(const FGamebaseLoggerCrashFilterDelegate& FilterDelegate) override;

private:
    UFUNCTION()
    void OnSuccess(const FGpLogEntry& Entry);
    
    UFUNCTION()
    void OnSave(const FGpLogEntry& Entry);
    
    UFUNCTION()
    void OnFilter(const FGpLogEntry& Entry, const FGpLogFilter& Filter);
    
    UFUNCTION()
    void OnError(const FGpLogEntry& Entry, const FString& ErrorMessage);
    
    UFUNCTION()
    bool IsCrashFilter(const FGpLoggerCrashData& CrashData);
    
private:
    FGamebaseLoggerListener GamebaseEventListener;
    FGamebaseLoggerCrashFilterDelegate GamebaseCrashFilter;
};