#include "GamebaseWebViewUtils.h"

#include "GenericPlatform/GenericPlatformHttp.h"

TSharedPtr<GamebaseWebViewUtils::FSchemeInfo> GamebaseWebViewUtils::GetSchemeInfo(const FString& InUrl)
{
    static const TCHAR* Delims[] = { TEXT("?"), TEXT("&") };
    
    TArray<FString> URLParameters;
    const int32 ArraySize = InUrl.ParseIntoArray(URLParameters, Delims, 2);
    if (ArraySize == 0)
    {
        return nullptr;
    }

    TSharedPtr<FSchemeInfo> SchemeInfo = MakeShared<FSchemeInfo>();
    SchemeInfo->Scheme = FGenericPlatformHttp::UrlDecode(URLParameters[0]);

    for (int i = 1; i < URLParameters.Num(); i++)
    {
        FString URLParameter = URLParameters[i];
        
        TArray<FString> Parameter;
        const int32 ParamSize = URLParameter.ParseIntoArray(Parameter, TEXT("="));
        if (ParamSize <= 1)
        {
            continue;
        }
        
        SchemeInfo->ParameterMap.FindOrAdd(FGenericPlatformHttp::UrlDecode(Parameter[0]), FGenericPlatformHttp::UrlDecode(Parameter[1]));
    }

    return SchemeInfo;
}
