#include "GamebaseTicker.h"

#if TICKER_OLD_ENGINE_VERSION
#include "Containers/Ticker.h"
#endif

FGamebaseTickerDelegateHandle GamebaseTicker::AddTicker(const FTickerDelegate& InDelegate, float InDelay)
{
#if TICKER_OLD_ENGINE_VERSION
    return FTicker::GetCoreTicker().AddTicker(InDelegate, InDelay);
#else
    return FTSTicker::GetCoreTicker().AddTicker(InDelegate, InDelay);
#endif
}

void GamebaseTicker::RemoveTicker(const FGamebaseTickerDelegateHandle& Handle)
{
#if TICKER_OLD_ENGINE_VERSION
    return FTicker::GetCoreTicker().RemoveTicker(Handle);
#else
    return FTSTicker::GetCoreTicker().RemoveTicker(Handle);
#endif
}
