#include "GamebaseConfigHelper.h"

namespace GamebaseConfigHelper
{
    const FString SectionName { TEXT("Gamebase") };
    const FString ConfigFileName = GGameIni;
}

FString GamebaseConfigHelper::GetString(
    const FString& Key,
    const FString& DefaultValue)
{
    FString OutValue;
    if (GConfig->GetString(*SectionName, *Key, OutValue, ConfigFileName))
    {
        return OutValue;
    }
    return DefaultValue;
}

int32 GamebaseConfigHelper::GetInt(
    const FString& Key,
    const int32 DefaultValue)
{
    int32 OutValue;
    if (GConfig->GetInt(*SectionName, *Key, OutValue, ConfigFileName))
    {
        return OutValue;
    }
    return DefaultValue;
}

float GamebaseConfigHelper::GetFloat(
    const FString& Key,
    const float DefaultValue)
{
    float OutValue;
    if (GConfig->GetFloat(*SectionName, *Key, OutValue, ConfigFileName))
    {
        return OutValue;
    }
    return DefaultValue;
}

bool GamebaseConfigHelper::GetBool(
    const FString& Key,
    const bool DefaultValue)
{
    bool OutValue;
    if (GConfig->GetBool(*SectionName, *Key, OutValue, ConfigFileName))
    {
        return OutValue;
    }
    return DefaultValue;
}