﻿#include "GamebaseSaveInfo.h"

#include "GeneralProjectSettings.h"

namespace GamebaseSaveInfo
{
    FString GetSection(const FString& ProjectName, const FString& AppId)
    {
        return FString::Printf(TEXT("%s/Gamebase/%s"), *ProjectName, *AppId);
    }
}

void GamebaseSaveInfo::SetStoreValue(const FString& AppId, const FString& Key, const FString& Value)
{
    const UGeneralProjectSettings& ProjectSettings = *GetDefault<UGeneralProjectSettings>();

    const FString CompanyName = ProjectSettings.CompanyName.IsEmpty() ? TEXT("Unknown") : ProjectSettings.CompanyName;
    const FString ProjectName = ProjectSettings.ProjectName.IsEmpty() ? TEXT("Unknown") : ProjectSettings.ProjectName;
    
    FPlatformMisc::SetStoredValue(CompanyName, GetSection(ProjectName, AppId), Key, Value);
}

TOptional<FString> GamebaseSaveInfo::GetStoreValue(const FString& AppId, const FString& Key)
{
    const UGeneralProjectSettings& ProjectSettings = *GetDefault<UGeneralProjectSettings>();

    const FString CompanyName = ProjectSettings.CompanyName.IsEmpty() ? TEXT("Unknown") : ProjectSettings.CompanyName;
    const FString ProjectName = ProjectSettings.ProjectName.IsEmpty() ? TEXT("Unknown") : ProjectSettings.ProjectName;
    
    FString GetValue;
    if (FPlatformMisc::GetStoredValue(CompanyName, GetSection(ProjectName, AppId), Key, GetValue))
    {
        return GetValue;
    }

    return TOptional<FString>();
}
