#pragma once

#include "CoreMinimal.h"
#include "GamebaseInternalDataPointer.h"
#include "IGamebaseDisplayLanguage.h"

class FGamebaseDisplayLanguage final : public IGamebaseDisplayLanguage
{
    class FLocalizedStrings;
    using FLocalizedStringsRef = TSharedRef<FLocalizedStrings>;
    
public:
    explicit FGamebaseDisplayLanguage(const FGamebaseInternalDataPtr& InternalData);
    virtual ~FGamebaseDisplayLanguage() override;

    virtual void SetLanguageCode(const FLanguageCode& LanguageCode) override;
    virtual void UpdateLaunchingLanguageCode(const FLanguageCode& DeviceLanguage, const FLanguageCode& DefaultLanguage) override;
    
    virtual FString GetDisplayLanguageCode() const override;
    virtual FString GetLocalizedString(const FLocalizedStringKey& Key) const override;
    
private:
    void LoadResources();
    
protected:
    FGamebaseInternalDataPtr InternalData;

    TOptional<FLanguageCode> ConfiguredCode;
    FLanguageCode DeviceCode;
    FLanguageCode DefaultCode;
    
    FLanguageCode DisplayCode;
    
    TMap<FLanguageCode, FLocalizedStringsRef> LocalizedStringsContainer;
};
