#pragma once

class FGamebaseDeviceInfo
{
public:
    static FGamebaseDeviceInfo& Get()
    {
        static FGamebaseDeviceInfo Instance;
        return Instance;
    }
    
    void Initialize();
    void InitializeCompleted();

    const TOptional<FString>& GetDeviceKey() const { return DeviceKey; }
    const TOptional<FString>& GetUUID() const { return UUID; }
    const TOptional<FString>& GetCountryCode() const { return CountryCode; }

private:
    FGamebaseDeviceInfo() = default;
    ~FGamebaseDeviceInfo() = default;

    FGamebaseDeviceInfo(const FGamebaseDeviceInfo&) = delete;
    FGamebaseDeviceInfo& operator=(const FGamebaseDeviceInfo&) = delete;

private:
    TOptional<FString> DeviceKey;
    TOptional<FString> UUID;
    TOptional<FString> CountryCode;

    TArray<FString> CachedErrors;
};
