#include "GamebaseGameThreadDispatcher.h"

#include "Async/Async.h"

#if UE_BUILD_DEVELOPMENT
#include "GamebaseLog.h"
#include "HAL/ThreadManager.h"
#endif

void GamebaseGameThreadDispatcher::Dispatch(TUniqueFunction<void()>&& Task)
{
    if (IsInGameThread())
    {
        Task();
    }
    else
    {
#if UE_BUILD_DEVELOPMENT
        const uint32 ThreadId = FPlatformTLS::GetCurrentThreadId();
        const FString ThreadName = FThreadManager::GetThreadName(ThreadId);

        GAMEBASE_LOG_DEBUG("Dispatching task on Async Thread (Thread ID: %d, Thread Name: %s)", ThreadId, *ThreadName);
#endif
        AsyncTask(ENamedThreads::GameThread, MoveTemp(Task));
    }
}