package com.toast.android.gamebase.ue4.communicator;

import com.google.gson.Gson;
import com.toast.android.gamebase.base.log.Logger;
import com.toast.android.gamebase.plugin.common.GamebaseJsonUtil;
import com.toast.android.gamebase.plugin.common.GamebasePluginUtil;
import com.toast.android.gamebase.plugin.communicator.message.NativeMessage;

public class GamebaseMessageSender {
    private String domain = GamebasePluginUtil.makeDomain(GamebaseMessageSender.class.getSimpleName());
    private String prefix = GamebasePluginUtil.makePrefix(GamebaseMessageSender.class.getSimpleName());
    private static GamebaseMessageSender instance;

    public static GamebaseMessageSender getInstance() {
        if (instance == null) {
            instance = new GamebaseMessageSender();
        }
        return instance;
    }

    public void sendMessage(NativeMessage message) {
        if (message == null) {
            Logger.w(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, "message is null. Failed to send ue4 message."));
        }
        
        String jsonString = new Gson().toJson(message);
        Logger.d(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, String.format("sendMessage jsonString : %s", GamebaseJsonUtil.toPrettyJsonString(message))));
        nativeSendMessage(jsonString);
    }
    
    // Callback that notify the C++ implementation that a task has completed
    public native void nativeSendMessage(String jsonString);
}