package com.toast.android.gamebase.ue4.communicator;

import com.google.gson.Gson;
import com.toast.android.gamebase.base.log.Logger;
import com.toast.android.gamebase.plugin.common.GamebaseJsonUtil;
import com.toast.android.gamebase.plugin.common.GamebasePluginUtil;
import com.toast.android.gamebase.plugin.communicator.DelegateManager;
import com.toast.android.gamebase.plugin.communicator.GamebaseListener;
import com.toast.android.gamebase.plugin.communicator.message.NativeMessage;
import com.toast.android.gamebase.plugin.communicator.message.EngineMessage;

public class GamebaseMessageReceiver {
    private static String domain = GamebasePluginUtil.makeDomain(GamebaseMessageReceiver.class.getSimpleName());
    private static String prefix = GamebasePluginUtil.makePrefix(GamebaseMessageReceiver.class.getSimpleName());

    public static void initialize(String className) {
        if (className.isEmpty()) {
            Logger.w(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, "className is empty. Failed to initializeClass."));
            return;
        }

        Logger.w(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, String.format("initialize className : %s", className)));

        try {
            initializeClass(className);
        } catch (Exception e) {
            Logger.w(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, String.format("initialize failed : %s", className)));
            Logger.w(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, e.toString()));
        }
    }

    private static void initializeClass(String className) throws Exception {
        try {
            Class clz = Class.forName(className);
            clz.newInstance();
        } catch (Exception e) {
            throw new Exception("Not supported className(" + className + ")", e);
        }
    }

    public static String getSync(String jsonData) {
        if (jsonData.isEmpty()) {
            Logger.w(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, "jsonData is empty. Failed to receive unreal message."));
            return "";
        }

        Logger.d(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, String.format("getSync jsonData : %s", GamebaseJsonUtil.toPrettyJsonString(jsonData))));

        EngineMessage message = new Gson().fromJson(jsonData, new EngineMessage().getClass());
        
        DelegateManager.SyncListener syncListener = DelegateManager.getSyncDelegate(message.scheme);
        if (syncListener == null)
        {
            Logger.w(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, String.format("Failed to find sync listener. (%s)", message.scheme)));
            return "";
        }
        
        String returnValue = syncListener.onSyncDelegate(jsonData, new GamebaseListener() {
            @Override
            public void onSendMessage(String sendJsonData, NativeMessage message) {
                GamebaseMessageSender.getInstance().sendMessage(message);
            }
        });

        Logger.d(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, String.format("getSync returnValue : %s", returnValue)));
        return returnValue;
    }

    public static void getAsync(String jsonData) {
        if (jsonData.isEmpty()) {
            Logger.w(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, "jsonData is empty. Failed to receive unreal message."));
            return;
        }

        Logger.d(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, String.format("getAsync jsonData : %s", GamebaseJsonUtil.toPrettyJsonString(jsonData))));

        EngineMessage message = new Gson().fromJson(jsonData, new EngineMessage().getClass());
        
        DelegateManager.AsyncListener asyncListener = DelegateManager.getAsyncDelegate(message.scheme);
        if (asyncListener == null)
        {
            Logger.w(GamebasePluginUtil.tag, GamebasePluginUtil.makeMessage(prefix, String.format("Failed to find async listener. (%s)", message.scheme)));
            return;
        }
        
        asyncListener.onAsyncDelegate(jsonData, new GamebaseListener() {
            @Override
            public void onSendMessage(String sendJsonData, NativeMessage message) {
                GamebaseMessageSender.getInstance().sendMessage(message);
            }
        });
    }
}