#import "GamebaseIOSLifecycle.h"
#import <Gamebase/Gamebase.h>

static void OnGamebaseOpenURL(UIApplication* application, NSURL* url, NSString* sourceApplication, id annotation)
{
    NSLog(@"[TCGB][Plugin][GamebaseIOSLifecycle] OnGamebaseOpenURL");
    [TCGBGamebase application:application
                      openURL:url
            sourceApplication:sourceApplication
                   annotation:annotation];
}

void FGamebaseIOSLifecycle::Initialize()
{
    FIOSCoreDelegates::OnOpenURL.AddStatic(&OnGamebaseOpenURL);
}

@implementation GamebaseIOSLifecycle

static GamebaseIOSLifecycle* GamebaseIOSLifecycleInstance = nil;

- (id)init {
    self = [super init];
    return self;
}

+(void)load
{
    [super load];
    if (GamebaseIOSLifecycleInstance == nil)
    {
        GamebaseIOSLifecycleInstance = [[GamebaseIOSLifecycle alloc] init];
        [GamebaseIOSLifecycleInstance registerLifeCycleListener];
    }
}

-(void)registerLifeCycleListener
{
    [[NSNotificationCenter defaultCenter]   addObserver :   self
                                               selector :   @selector(didFinishLaunching:)
                                                   name :   UIApplicationDidFinishLaunchingNotification
                                                 object :   nil];
    
    [[NSNotificationCenter defaultCenter]   addObserver :   self
                                               selector :   @selector(didBecomeActive:)
                                                   name :   UIApplicationDidBecomeActiveNotification
                                                 object :   nil];
    
    [[NSNotificationCenter defaultCenter]   addObserver :   self
                                               selector :   @selector(willResignActive:)
                                                   name :   UIApplicationWillResignActiveNotification
                                                 object :   nil];
    
    [[NSNotificationCenter defaultCenter]   addObserver :   self
                                               selector :   @selector(didEnterBackground:)
                                                   name :   UIApplicationDidEnterBackgroundNotification
                                                 object :   nil];
    
    [[NSNotificationCenter defaultCenter]   addObserver :   self
                                               selector :   @selector(willEnterForeground:)
                                                   name :   UIApplicationWillEnterForegroundNotification
                                                 object :   nil];
    
    [[NSNotificationCenter defaultCenter]   addObserver :   self
                                               selector :   @selector(willTerminate:)
                                                   name :   UIApplicationWillTerminateNotification
                                                 object :   nil];
    
    [[NSNotificationCenter defaultCenter]   addObserver :   self
                                               selector :   @selector(applicationDidReceiveMemoryWarning:)
                                                   name :   UIApplicationDidReceiveMemoryWarningNotification
                                                 object :   nil];
    
    [[NSNotificationCenter defaultCenter]   addObserver :   self
                                               selector :   @selector(applicationSignificantTimeChange:)
                                                   name :   UIApplicationSignificantTimeChangeNotification
                                                 object :   nil];
}

#pragma mark - LifeCycleListener
- (void)didFinishLaunching:(NSNotification*)notification {
    NSLog(@"[TCGB][Plugin][GamebaseIOSLifecycle] didFinishLaunching");
    [TCGBGamebase application:[UIApplication sharedApplication] didFinishLaunchingWithOptions:[notification userInfo]];
}

- (void)didBecomeActive:(NSNotification*)notification {
    NSLog(@"[TCGB][Plugin][GamebaseIOSLifecycle] didBecomeActive");
    [TCGBGamebase applicationDidBecomeActive:[UIApplication sharedApplication]];
}

- (void)willResignActive:(NSNotification*)notification {
    NSLog(@"[TCGB][Plugin][GamebaseIOSLifecycle] willResignActive");
    [TCGBGamebase applicationWillResignActive:[UIApplication sharedApplication]];
}

- (void)didEnterBackground:(NSNotification*)notification {
    NSLog(@"[TCGB][Plugin][GamebaseIOSLifecycle] didEnterBackground");
    [TCGBGamebase applicationDidEnterBackground:[UIApplication sharedApplication]];
}

- (void)willEnterForeground:(NSNotification*)notification {
    NSLog(@"[TCGB][Plugin][GamebaseIOSLifecycle] willEnterForeground");
    [TCGBGamebase applicationWillEnterForeground:[UIApplication sharedApplication]];
}

- (void)willTerminate:(NSNotification*)notification {
    NSLog(@"[TCGB][Plugin][GamebaseIOSLifecycle] willTerminate");
    [TCGBGamebase applicationWillTerminate:[UIApplication sharedApplication]];
}

- (void)applicationDidReceiveMemoryWarning:(NSNotification*)notification {
    NSLog(@"[TCGB][Plugin][GamebaseIOSLifecycle] applicationDidReceiveMemoryWarning");
    [TCGBGamebase applicationDidReceiveMemoryWarning:[UIApplication sharedApplication]];
}

- (void)applicationSignificantTimeChange:(NSNotification*)notification {
    NSLog(@"[TCGB][Plugin][GamebaseIOSLifecycle] applicationSignificantTimeChange");
    [TCGBGamebase applicationSignificantTimeChange:[UIApplication sharedApplication]];
}
@end
