#import "UnrealMessageSender.h"
#import <GamebasePlugin/GamebasePlugin.h>

@implementation UnrealMessageSender

+(UnrealMessageSender*)sharedUnrealMessageSender {
    static dispatch_once_t onceToken;
    static UnrealMessageSender* instance = nil;
    dispatch_once(&onceToken, ^{
        instance = [[UnrealMessageSender alloc] init];
    });
    return instance;
}

-(void)sendMessage:(NativeMessage*)message {
    NativeMessage* responseMessage = message;
    NSString* jsonString = [responseMessage toJsonString];
    
    if (jsonString == nil){
        NSLog(@"[TCGB][Plugin][UnrealMessageSender] JsonString is nil.");
    }
    else {
        NSLog(@"[TCGB][Plugin][UnrealMessageSender] sendMessage jsonString : %@", jsonString);
        
        IGamebaseCommunicator::ReceiveMessage(FString([jsonString description]));
    }
}
@end
