#import "UnrealMessageSender.h"
#import "TCGBUnrealViewController.h"
#import <GamebasePlugin/GamebasePlugin.h>
#import <Gamebase/Gamebase.h>
#import <Foundation/Foundation.h>

@interface TCGBUnrealInterface : NSObject

+ (TCGBUnrealInterface *)sharedInterface;

@property (atomic, strong) id<TCGBViewControllerDelegate> viewControllerDelegate;

@end

@implementation TCGBUnrealInterface

+ (TCGBUnrealInterface *)sharedInterface {
    static dispatch_once_t onceToken;
    static TCGBUnrealInterface* instance;
    dispatch_once(&onceToken, ^{
        instance = [[TCGBUnrealInterface alloc] init];
    });
    return instance;
}

- (void)setupViewController {
    _viewControllerDelegate = [[TCGBUnrealViewController alloc] init];
    [[TCGBViewControllerManager sharedGamebaseViewControllerManager] setDelegate:_viewControllerDelegate];
}

@end

#pragma mark - extern C
extern "C" {
    void initialize(char* className)
    {
        [[TCGBUnrealInterface sharedInterface] setupViewController];
        
        Class newClass = NSClassFromString([NSString stringWithUTF8String:className]);
        if(newClass != nil)
        {
            id newInstance = [[newClass alloc] init];
            if(newInstance == nil)
            {
                NSLog(@"[TCGB][Plugin][UnrealMessageReceiver] initialize fail : %s", className);
                return;
            }
            [[DelegateManager sharedDelegateManager] addClass:newInstance];
            GamebaseEngine.engineType = @"UNREAL";
        }
    }
    
    char* getSync(char* jsonString) {
        NSString *data = [NSString string];
        
        if (jsonString != nil) {
            data = [NSString stringWithUTF8String:jsonString];
        }
        
        if (data != nil) {
            NSLog(@"[TCGB][Plugin][UnrealMessageReceiver] getSync jsonString : %@", data);
        }
        
        NSDictionary* convertedDic = [data toJSONDictionary];
        NSInvocation* invocation = [[DelegateManager sharedDelegateManager] getSyncDelegate:convertedDic[@"scheme"]];
        
        void *invokeReturnChar = nil;
        if (invocation) {
            TCGBPluginData* pluginData = [[TCGBPluginData alloc]initWithJsonData:data completion:^(NSString *jsonData, NativeMessage *message) {
                [[UnrealMessageSender sharedUnrealMessageSender] sendMessage:message];
            }];
            
            [invocation setArgument:&pluginData atIndex:2];
            [invocation invoke];
            [invocation getReturnValue:&invokeReturnChar];
        }
        
        NSString *returnCharBridged = (__bridge NSString *)invokeReturnChar;
        if (returnCharBridged == nil) {
            returnCharBridged = @"";
        }
        
        char *returnValue = (char*)[returnCharBridged UTF8String];
        NSLog(@"[TCGB][Plugin][UnrealMessageReceiver] getSync returnValue : %s", returnValue);
        return returnValue;
    }
    
    void getAsync(char* jsonString) {
        NSString *data = [NSString string];
      
        if (jsonString != nil) {
            data = [NSString stringWithUTF8String:jsonString];
        }
        
        if (data != nil) {
            NSLog(@"[TCGB][Plugin][UnrealMessageReceiver] getAsync jsonString : %@", data);
        }
        
        NSDictionary* convertedDic = [data toJSONDictionary];
        NSInvocation* invocation = [[DelegateManager sharedDelegateManager] getAsyncDelegate:convertedDic[@"scheme"]];
        if (invocation) {
            dispatch_async(dispatch_get_main_queue(), ^{
                TCGBPluginData* pluginData = [[TCGBPluginData alloc]initWithJsonData:data completion:^(NSString *jsonData, NativeMessage *message) {
                    [[UnrealMessageSender sharedUnrealMessageSender] sendMessage:message];
                }];
    
                [invocation setArgument:&pluginData atIndex:2];
                [invocation invoke];
            });
        }
    }
}

