#include "GamebaseIOSPush.h"
#include "GamebaseCommunicationRequestTypes.h"

namespace GamebaseScheme
{
    const FName SetSandboxMode(TEXT("gamebase://setSandboxMode"));
}

void FGamebaseIOSPush::SetSandboxMode(const bool bIsSandbox)
{
    FPushIsSandboxMode ModeData;
    ModeData.bIsSandbox = bIsSandbox;

    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::SetSandboxMode };
    SendData.JsonData = ModeData.ToJson(false);

    Communicator->GetAsync(SendData);
}
