#pragma once

#include "GamebaseBridgeBase.h"
#include "Interfaces/IGamebaseWebView.h"

class FGamebaseBridgeWebView : public IGamebaseWebView, public FGamebaseBridgeBase
{
public:
    explicit FGamebaseBridgeWebView(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName = {});
    virtual ~FGamebaseBridgeWebView() override = default;

    virtual void OpenWebBrowser(const FString& Url) override;
    virtual void ShowWebView(const FString& Url, const FGamebaseWebViewConfiguration& Configuration,
        const FGamebaseErrorDelegate& CloseCallback, const TArray<FString>& SchemeList, const FGamebaseSchemeEventDelegate& SchemeEvent) override;
    virtual void CloseWebView() override;

private:
    int32 RegisterSchemeEvent(const FGamebaseSchemeEventDelegate& SchemeEvent);
    void UnregisterSchemeEvent(const FString& ExtraData);

private:
    TMap<int32, FGamebaseSchemeEventDelegate> OnSchemeEventMap;
};
