#include "GamebaseBridgeUtil.h"
#include "GamebaseCommunicationRequestTypes.h"

namespace GamebaseScheme
{
    const FName ShowToastWithType(TEXT("gamebase://showToastWithType"));
    const FName ShowAlert(TEXT("gamebase://showAlert"));
    const FName ShowAlertEvent(TEXT("gamebase://showAlertEvent"));
}


FGamebaseBridgeUtil::FGamebaseBridgeUtil(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeUtil::ShowAlert(const FString& Title, const FString& Message)
{
    FUtilAlertDialog DialogData;
    DialogData.Title = Title;
    DialogData.Message = Message;

    FGamebaseCommunicatorSendData SendData { GamebaseScheme::ShowAlert };
    SendData.JsonData = DialogData.ToJson(false);

    Communicator->GetAsync(SendData);
}

void FGamebaseBridgeUtil::ShowAlert(const FString& Title, const FString& Message, const FGamebaseAlertCloseDelegate& CloseCallback)
{
    FUtilAlertDialog DialogData;
    DialogData.Title = Title;
    DialogData.Message = Message;

    FGamebaseCommunicatorSendData SendData { GamebaseScheme::ShowAlertEvent };
    SendData.JsonData = DialogData.ToJson(false);

    Communicator->GetAsync(SendData, CloseCallback);
}

void FGamebaseBridgeUtil::ShowToast(const FString& Message, EGamebaseToastExposureTime ExposureTimeType)
{
    FUtilAlertDialog DialogData;
    DialogData.Message = Message;
    DialogData.Duration = static_cast<int32>(ExposureTimeType);

    FGamebaseCommunicatorSendData SendData { GamebaseScheme::ShowToastWithType };
    SendData.JsonData = DialogData.ToJson(false);

    Communicator->GetAsync(SendData);
}

void FGamebaseBridgeUtil::ShowAlert(TMap<FString, FString> Parameters, const FGamebaseAlertDelegate& Callback)
{
    static const FString KeyTitle(TEXT("title"));
    static const FString KeyMessage(TEXT("message"));
    static const FString KeyButtonLeft(TEXT("buttonLeft"));
    static const FString KeyButtonRight(TEXT("buttonRight"));
    
    FUtilAlertDialog DialogData;
    DialogData.Title = KeyTitle;
    DialogData.Message = KeyMessage;

    FGamebaseCommunicatorSendData SendData { GamebaseScheme::ShowAlertEvent };
    SendData.JsonData = DialogData.ToJson(false);

    //TODO: 확인 필요
    Communicator->GetAsync(SendData, Callback);
}