#include "GamebaseBridgeTerms.h"

namespace GamebaseScheme
{
    const FName ShowTermsView (TEXT("gamebase://showTermsView"));
    const FName ShowTermsViewWithConfiguration (TEXT("gamebase://showTermsViewWithConfiguration"));
    const FName UpdateTerms(TEXT("gamebase://updateTerms"));
    const FName QueryTerms(TEXT("gamebase://queryTerms"));
    const FName IsShowingTermsView(TEXT("gamebase://isShowingTermsView"));
}

FGamebaseBridgeTerms::FGamebaseBridgeTerms(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeTerms::ShowTermsView(const FGamebaseDataContainerDelegate& CloseCallback)
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::ShowTermsView };

    Communicator->GetAsync(SendData, CloseCallback);
}

void FGamebaseBridgeTerms::ShowTermsView(const FGamebaseTermsConfiguration& Configuration, const FGamebaseDataContainerDelegate& CloseCallback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::ShowTermsViewWithConfiguration };
    SendData.JsonData = Configuration.ToJson();

    Communicator->GetAsync(SendData, CloseCallback);
}

void FGamebaseBridgeTerms::UpdateTerms(const FGamebaseUpdateTermsConfiguration& Configuration, const FGamebaseErrorDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::UpdateTerms };
    SendData.JsonData = Configuration.ToJson();

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgeTerms::QueryTerms(const FGamebaseQueryTermsResultDelegate& Callback)
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::QueryTerms };

    Communicator->GetAsync(SendData, Callback);
}

bool FGamebaseBridgeTerms::IsShowingTermsView()
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::IsShowingTermsView };

    const FString GetJsonString = Communicator->GetSync(SendData);
    if (GetJsonString.IsEmpty())
    {
        return false;
    }

    return GetJsonString.ToBool();
}