#pragma once

#include "GamebaseBridgeBase.h"
#include "Interfaces/IGamebaseSystemInfo.h"

class FGamebaseBridgeSystemInfo : public IGamebaseSystemInfo, public FGamebaseBridgeBase
{
public:
    explicit FGamebaseBridgeSystemInfo(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName = {});
    virtual ~FGamebaseBridgeSystemInfo() override = default;

    virtual void RequestLastLoggedInProvider(const FGamebaseLastLoggedInProviderDelegate& Callback) const override;
    virtual FString GetLastLoggedInProvider() const override;

    virtual FString GetUserID() const override;
    virtual FString GetAccessToken() const override;

    virtual FString GetSDKVersion() const override;
    virtual bool IsSandbox() const override;

    virtual FString GetDisplayLanguageCode() const override;
    virtual void SetDisplayLanguageCode(const FString& LanguageCode) override;

    virtual FString GetDeviceLanguageCode() const override;
    virtual FString GetCarrierCode() const override;
    virtual FString GetCarrierName() const override;
    virtual FString GetCountryCode() const override;
    virtual FString GetCountryCodeOfUSIM() const override;
    virtual FString GetCountryCodeOfDevice() const override;
};
