#include "GamebaseBridgeSystemInfo.h"

namespace GamebaseScheme
{
    const FName RequestLastLoggedInProvider(TEXT("gamebase://requestLastLoggedInProvider"));
    const FName GetLastLoggedInProvider(TEXT("gamebase://getLastLoggedInProvider"));

    const FName GetUserID(TEXT("gamebase://getUserID"));
    const FName GetAccessToken(TEXT("gamebase://getAccessToken"));

    const FName GetSDKVersion(TEXT("gamebase://getSDKVersion"));
    const FName IsSandbox(TEXT("gamebase://isSandbox"));

    const FName SetDisplayLanguageCode(TEXT("gamebase://setDisplayLanguageCode"));
    const FName GetDisplayLanguageCode(TEXT("gamebase://getDisplayLanguageCode"));

    const FName GetDeviceLanguageCode(TEXT("gamebase://getDeviceLanguageCode"));
    const FName GetCarrierCode(TEXT("gamebase://getCarrierCode"));
    const FName GetCarrierName(TEXT("gamebase://getCarrierName"));
    const FName GetCountryCode(TEXT("gamebase://getCountryCode"));
    const FName GetCountryCodeOfUSIM(TEXT("gamebase://getCountryCodeOfUSIM"));
    const FName GetCountryCodeOfDevice(TEXT("gamebase://getCountryCodeOfDevice"));
}

FGamebaseBridgeSystemInfo::FGamebaseBridgeSystemInfo(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeSystemInfo::RequestLastLoggedInProvider(const FGamebaseLastLoggedInProviderDelegate& Callback) const
{
    const FGamebaseCommunicatorSendData SendData { GamebaseScheme::RequestLastLoggedInProvider };

    Communicator->GetAsync(SendData, Callback);
}

FString FGamebaseBridgeSystemInfo::GetLastLoggedInProvider() const
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::GetLastLoggedInProvider };
    return Communicator->GetSync(SendData);
}

FString FGamebaseBridgeSystemInfo::GetUserID() const
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::GetUserID };
    return Communicator->GetSync(SendData);
}

FString FGamebaseBridgeSystemInfo::GetAccessToken() const
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::GetAccessToken };
    return Communicator->GetSync(SendData);
}

FString FGamebaseBridgeSystemInfo::GetSDKVersion() const
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::GetSDKVersion };
    return Communicator->GetSync(SendData);
}

bool FGamebaseBridgeSystemInfo::IsSandbox() const
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::IsSandbox };
    const FString GetJsonString = Communicator->GetSync(SendData);
    if (GetJsonString.IsEmpty())
    {
        return false;
    }

    const TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<>::Create(GetJsonString);
    TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject());

    if (FJsonSerializer::Deserialize(JsonReader, JsonObject) == false)
    {
        return false;
    }

    return JsonObject->GetBoolField("isSandbox");
}

FString FGamebaseBridgeSystemInfo::GetDisplayLanguageCode() const
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::GetDisplayLanguageCode };
    return Communicator->GetSync(SendData);
}

void FGamebaseBridgeSystemInfo::SetDisplayLanguageCode(const FString& LanguageCode)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::SetDisplayLanguageCode };
    SendData.JsonData = LanguageCode;
    
    Communicator->GetSync(SendData);
}

FString FGamebaseBridgeSystemInfo::GetDeviceLanguageCode() const
{
    const FGamebaseCommunicatorSendData SendData { GamebaseScheme::GetDeviceLanguageCode };
    return Communicator->GetSync(SendData);
}

FString FGamebaseBridgeSystemInfo::GetCarrierCode() const
{
    const FGamebaseCommunicatorSendData SendData { GamebaseScheme::GetCarrierCode };
    return Communicator->GetSync(SendData);
}

FString FGamebaseBridgeSystemInfo::GetCarrierName() const
{
    const FGamebaseCommunicatorSendData SendData { GamebaseScheme::GetCarrierName };
    return Communicator->GetSync(SendData);
}

FString FGamebaseBridgeSystemInfo::GetCountryCode() const
{
    const FGamebaseCommunicatorSendData SendData { GamebaseScheme::GetCountryCode };
    return Communicator->GetSync(SendData);
}

FString FGamebaseBridgeSystemInfo::GetCountryCodeOfUSIM() const
{
    const FGamebaseCommunicatorSendData SendData { GamebaseScheme::GetCountryCodeOfUSIM };
    return Communicator->GetSync(SendData);
}

FString FGamebaseBridgeSystemInfo::GetCountryCodeOfDevice() const
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::GetCountryCodeOfDevice };
    return Communicator->GetSync(SendData);
}