#include "GamebaseBridgePush.h"

namespace GamebaseScheme
{
    const FName RegisterPush(TEXT("gamebase://registerPush"));
    const FName QueryPush(TEXT("gamebase://queryPush"));
    const FName RegisterPushWithOption(TEXT("gamebase://registerPushWithOption"));
    const FName QueryTokenInfo(TEXT("gamebase://queryTokenInfo"));
    const FName GetNotificationOptions(TEXT("gamebase://getNotificationOptions"));
    const FName QueryNotificationAllowed(TEXT("gamebase://queryNotificationAllowed"));
}

FGamebaseBridgePush::FGamebaseBridgePush(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgePush::RegisterPush(const FGamebasePushConfiguration& Configuration, const FGamebaseErrorDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::RegisterPush };
    SendData.JsonData = Configuration.ToJson();

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePush::RegisterPush(const FGamebasePushConfiguration& Configuration, const FGamebaseNotificationOptions& NotificationOptions, const FGamebaseErrorDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::RegisterPushWithOption };
    SendData.JsonData = Configuration.ToJson();
    SendData.ExtraData = NotificationOptions.ToJson();

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePush::QueryTokenInfo(const FGamebasePushTokenInfoDelegate& Callback)
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::QueryTokenInfo };

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePush::QueryPush(const FGamebasePushConfigurationDelegate& Callback)
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::QueryPush };

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePush::SetSandboxMode(bool bIsSandbox)
{
    GAMEBASE_NOT_SUPPORT_API();
}

FGamebaseNotificationOptionsPtr FGamebaseBridgePush::GetNotificationOptions()
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::GetNotificationOptions };

    const FString GetJsonString = Communicator->GetSync(SendData);
    if (GetJsonString.IsEmpty())
    {
        return nullptr;
    }
    const FGamebaseNotificationOptionsPtr Options = MakeShared<FGamebaseNotificationOptions, ESPMode::ThreadSafe>();
    Options->FromJson(GetJsonString);

    return Options;
}

void FGamebaseBridgePush::QueryNotificationAllowed(const FGamebaseQueryNotificationAllowedDelegate& Callback)
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::QueryNotificationAllowed };

    Communicator->GetAsync(SendData, Callback);
}
